#include "regreasons.h"

RegReasons::RegReasons() noexcept
    : flags_()
{

}

RegReasons::RegReasons(const fdf::Reasons &flags) noexcept
    : flags_(flags)
{

}

RegReasons::RegReasons(const QVariantMap &map) noexcept
    :flags_()
{
    parseMap(map);
}

RegReasons::RegReasons(const RegReasons &other) noexcept
    :flags_(other.flags_)
{

}

RegReasons::RegReasons(RegReasons &&other) noexcept
    : flags_(other.flags_)
{

}

RegReasons::~RegReasons()
{

}

bool RegReasons::firstRegistraion() const
{
    return static_cast<quint32>(flags_) == 0u;
}

bool RegReasons::changeFs() const
{
    return getFsChange();
}

bool RegReasons::fsReRegistration() const
{
    return !firstRegistraion() && !changeFs();
}

const fdf::Reasons &RegReasons::flags() const
{
    return flags_;
}

void RegReasons::setFlags(const fdf::Reasons &newFlags)
{
    flags_ = newFlags;
}

void RegReasons::setReason(fdf::Reason r, bool set)
{
    flags_.setFlag(r, set);
}

bool RegReasons::getFsChange() const
{
    return flags_.testFlag(fdf::Reason::FsChange);
}

void RegReasons::setFsChange(bool set)
{
    flags_.setFlag(fdf::Reason::FsChange, set);
}

bool RegReasons::getOfdChange() const
{
    return flags_.testFlag(fdf::Reason::OfdChange);
}

void RegReasons::setOfdChange(bool set)
{
    flags_.setFlag(fdf::Reason::OfdChange, set);
}

bool RegReasons::getUserNameChange() const
{
    return flags_.testFlag(fdf::Reason::UserNameChange);
}

void RegReasons::setUserNameChange(bool set)
{
    flags_.setFlag(fdf::Reason::UserNameChange, set);
}

bool RegReasons::getAddressChange() const
{
    return flags_.testFlag(fdf::Reason::AddressChange);
}

void RegReasons::setAddressChange(bool set)
{
    flags_.setFlag(fdf::Reason::AddressChange, set);
}

bool RegReasons::getOfflineToOnline() const
{
    return flags_.testFlag(fdf::Reason::OfflineToOnline);
}

void RegReasons::setOfflineToOnline(bool set)
{
    flags_.setFlag(fdf::Reason::OfflineToOnline, set);
}

bool RegReasons::getOnlineToOffline() const
{
    return flags_.testFlag(fdf::Reason::OnlineToOffline);
}

void RegReasons::setOnlineToOffline(bool set)
{
    flags_.setFlag(fdf::Reason::OnlineToOffline, set);
}

bool RegReasons::getCashboxVersionChange() const
{
    return flags_.testFlag(fdf::Reason::CashboxVersionChange);
}

void RegReasons::setCashboxVersionChange(bool set)
{
    flags_.setFlag(fdf::Reason::CashboxVersionChange, set);
}

bool RegReasons::getTaxesChange() const
{
    return flags_.testFlag(fdf::Reason::TaxesChange);
}

void RegReasons::setTaxesChange(bool set)
{
    flags_.setFlag(fdf::Reason::TaxesChange, set);
}

bool RegReasons::getBoxIdChange() const
{
    return flags_.testFlag(fdf::Reason::BoxIdChange);
}

void RegReasons::setBoxIdChange(bool set)
{
    flags_.setFlag(fdf::Reason::BoxIdChange, set);
}

bool RegReasons::getAutoToSingle() const
{
    return flags_.testFlag(fdf::Reason::AutoToSingle);
}

void RegReasons::setAutoToSingle(bool set)
{
    flags_.setFlag(fdf::Reason::AutoToSingle, set);
}

bool RegReasons::getSingleToAuto() const
{
    return flags_.testFlag(fdf::Reason::SingleToAuto);
}

void RegReasons::setSingleToAuto(bool set)
{
    flags_.setFlag(fdf::Reason::SingleToAuto, set);
}

bool RegReasons::getBasicToFosa() const
{
    return flags_.testFlag(fdf::Reason::BasicToFosa);
}

void RegReasons::setBasicToFosa(bool set)
{
    flags_.setFlag(fdf::Reason::BasicToFosa, set);
}

bool RegReasons::getFosaToBasic() const
{
    return flags_.testFlag(fdf::Reason::FosaToBasic);
}

void RegReasons::setFosaToBasic(bool set)
{
    flags_.setFlag(fdf::Reason::FosaToBasic, set);
}

bool RegReasons::getInternetToBasic() const
{
    return flags_.testFlag(fdf::Reason::InternetToBasic);
}

void RegReasons::setInternetToBasic(bool set)
{
    flags_.setFlag(fdf::Reason::InternetToBasic, set);
}

bool RegReasons::getBasicToInternet() const
{
    return flags_.testFlag(fdf::Reason::BasicToInternet);
}

void RegReasons::setBasicToInternet(bool set)
{
    flags_.setFlag(fdf::Reason::BasicToInternet, set);
}

bool RegReasons::getGamesToBasic() const
{
    return flags_.testFlag(fdf::Reason::GamesToBasic);
}

void RegReasons::setGamesToBasic(bool set)
{
    flags_.setFlag(fdf::Reason::GamesToBasic, set);
}

bool RegReasons::getBasicToGames() const
{
    return flags_.testFlag(fdf::Reason::BasicToGames);
}

void RegReasons::setBasicToGames(bool set)
{
    flags_.setFlag(fdf::Reason::BasicToGames, set);
}

bool RegReasons::getLotteryToBasic() const
{
    return flags_.testFlag(fdf::Reason::LotteryToBasic);
}

void RegReasons::setLotteryToBasic(bool set)
{
    flags_.setFlag(fdf::Reason::LotteryToBasic, set);
}

bool RegReasons::getBasicToLottery() const
{
    return flags_.testFlag(fdf::Reason::BasicToLottery);
}

void RegReasons::setBasicToLottery(bool set)
{
    flags_.setFlag(fdf::Reason::BasicToLottery, set);
}

bool RegReasons::getFFDChange() const
{
    return flags_.testFlag(fdf::Reason::FFDChange);
}

void RegReasons::setFFDChange(bool set)
{
    flags_.setFlag(fdf::Reason::FFDChange, set);
}

bool RegReasons::getAnotherReasons() const
{
    return flags_.testFlag(fdf::Reason::AnotherReasons);
}

void RegReasons::setAnotherReasons(bool set)
{
    flags_.setFlag(fdf::Reason::AnotherReasons, set);
}

QVariantMap RegReasons::toMap() const
{
    return {
        {"reason", QString::number(static_cast<quint32>(flags_))}
    };
}

/*
        FsChange
        OfdChange
        UserNameChange
        AddressChange
        OfflineToOnline
        OnlineToOffline
        CashboxVersionChange
        TaxesChange
        BoxIdChange
        AutoToSingle
        SingleToAuto
        BasicToFosa
        FosaToBasic
        InternetToBasic
        BasicToInternet
        GamesToBasic
        BasicToGames
        LotteryToBasic
        BasicToLottery
        FFDChange
        AnotherReasons
*/

QVariantMap RegReasons::toExternalMap() const
{
    return {
        {"fsChange"             ,         getFsChange             ()},
        {"ofdChange"            ,         getOfdChange            ()},
        {"userNameChange"       ,         getUserNameChange       ()},
        {"addressChange"        ,         getAddressChange        ()},
        {"offlineToOnline"      ,         getOfflineToOnline      ()},
        {"onlineToOffline"      ,         getOnlineToOffline      ()},
        {"cashboxVersionChange" ,         getCashboxVersionChange ()},
        {"taxesChange"          ,         getTaxesChange          ()},
        {"boxIdChange"          ,         getBoxIdChange          ()},
        {"autoToSingle"         ,         getAutoToSingle         ()},
        {"singleToAuto"         ,         getSingleToAuto         ()},
        {"basicToFosa"          ,         getBasicToFosa          ()},
        {"fosaToBasic"          ,         getFosaToBasic          ()},
        {"internetToBasic"      ,         getInternetToBasic      ()},
        {"basicToInternet"      ,         getBasicToInternet      ()},
        {"gamesToBasic"         ,         getGamesToBasic         ()},
        {"basicToGames"         ,         getBasicToGames         ()},
        {"lotteryToBasic"       ,         getLotteryToBasic       ()},
        {"basicToLottery"       ,         getBasicToLottery       ()},
        {"ffdChange"            ,         getFFDChange            ()},
        {"anotherReasons"       ,         getAnotherReasons       ()},
    };
}

void RegReasons::parseMap(const QVariantMap &map)
{
    if(map.contains("reason"))
    {
        flags_ = fdf::Reasons(map["reason"].toString().toUInt());
    }
    else
    {
        setFsChange(map.contains("fsChange") && map["fsChange"].toBool());
        setOfdChange           (map.contains("ofdChange") && map["ofdChange"].toBool());
        setUserNameChange      (map.contains("userNameChange") && map["userNameChange"].toBool());
        setAddressChange       (map.contains("addressChange") && map["addressChange"].toBool());
        setOfflineToOnline     (map.contains("offlineToOnline") && map["offlineToOnline"].toBool());
        setOnlineToOffline     (map.contains("onlineToOffline") && map["onlineToOffline"].toBool());
        setCashboxVersionChange(map.contains("cashboxVersionChange") && map["cashboxVersionChange"].toBool());
        setTaxesChange         (map.contains("taxesChange") && map["taxesChange"].toBool());
        setBoxIdChange         (map.contains("boxIdChange") && map["boxIdChange"].toBool());
        setAutoToSingle        (map.contains("autoToSingle") && map["autoToSingle"].toBool());
        setSingleToAuto        (map.contains("singleToAuto") && map["singleToAuto"].toBool());
        setBasicToFosa         (map.contains("basicToFosa") && map["basicToFosa"].toBool());
        setFosaToBasic         (map.contains("fosaToBasic") && map["fosaToBasic"].toBool());
        setInternetToBasic     (map.contains("internetToBasic") && map["internetToBasic"].toBool());
        setBasicToInternet     (map.contains("basicToInternet") && map["basicToInternet"].toBool());
        setGamesToBasic        (map.contains("gamesToBasic") && map["gamesToBasic"].toBool());
        setBasicToGames        (map.contains("basicToGames") && map["basicToGames"].toBool());
        setLotteryToBasic      (map.contains("lotteryToBasic") && map["lotteryToBasic"].toBool());
        setBasicToLottery      (map.contains("basicToLottery") && map["basicToLottery"].toBool());
        setFFDChange           (map.contains("ffdChange") && map["ffdChange"].toBool());
        setAnotherReasons      (map.contains("anotherReasons") && map["anotherReasons"].toBool());
    }
}

quint32 RegReasons::toUInt() const
{
    return static_cast<quint32>(flags_);
}

RegReasons &RegReasons::operator =(const RegReasons &other) noexcept
{
    flags_ = other.flags_;
    return *this;
}

RegReasons &RegReasons::operator =(RegReasons &&other) noexcept
{
    flags_ = other.flags_;
    return *this;
}

bool RegReasons::operator ==(const RegReasons &other) const noexcept
{
    return flags_ == other.flags_;
}

bool RegReasons::operator !=(const RegReasons &other) const noexcept
{
    return flags_ != other.flags_;
}
