#ifndef REGREASONS_H
#define REGREASONS_H

#include "fdfconstants.h"

#include <QVariantMap>

class RegReasons
{
public:
    RegReasons()noexcept;
    explicit RegReasons(const fdf::Reasons &flags) noexcept;
    explicit RegReasons(const QVariantMap &map)noexcept;
    RegReasons(const RegReasons &other)noexcept;
    RegReasons(RegReasons &&other)noexcept;
    ~RegReasons();

    bool firstRegistraion() const;
    bool changeFs() const;
    bool fsReRegistration() const;

    const fdf::Reasons &flags() const;
    void setFlags(const fdf::Reasons &newFlags);
    void setReason(fdf::Reason r, bool set);

    bool getFsChange()const;
    void setFsChange(bool set);
    bool getOfdChange()const;
    void setOfdChange(bool set);
    bool getUserNameChange()const;
    void setUserNameChange(bool set);
    bool getAddressChange()const;
    void setAddressChange(bool set);
    bool getOfflineToOnline()const;
    void setOfflineToOnline(bool set);
    bool getOnlineToOffline()const;
    void setOnlineToOffline(bool set);
    bool getCashboxVersionChange()const;
    void setCashboxVersionChange(bool set);
    bool getTaxesChange()const;
    void setTaxesChange(bool set);
    bool getBoxIdChange()const;
    void setBoxIdChange(bool set);
    bool getAutoToSingle()const;
    void setAutoToSingle(bool set);
    bool getSingleToAuto()const;
    void setSingleToAuto(bool set);
    bool getBasicToFosa()const;
    void setBasicToFosa(bool set);
    bool getFosaToBasic()const;
    void setFosaToBasic(bool set);
    bool getInternetToBasic()const;
    void setInternetToBasic(bool set);
    bool getBasicToInternet()const;
    void setBasicToInternet(bool set);
    bool getGamesToBasic()const;
    void setGamesToBasic(bool set);
    bool getBasicToGames()const;
    void setBasicToGames(bool set);
    bool getLotteryToBasic()const;
    void setLotteryToBasic(bool set);
    bool getBasicToLottery()const;
    void setBasicToLottery(bool set);
    bool getFFDChange()const;
    void setFFDChange(bool set);
    bool getAnotherReasons()const;
    void setAnotherReasons(bool set);

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);
    quint32 toUInt() const;


    RegReasons &operator =(const RegReasons &other) noexcept;
    RegReasons &operator =(RegReasons &&other)noexcept;
    bool operator ==(const RegReasons &other)const noexcept;
    bool operator !=(const RegReasons &other)const noexcept;

private:
    fdf::Reasons flags_;
};

#endif // REGREASONS_H
