#ifndef SIMPLERECEIPTOPERATION_H
#define SIMPLERECEIPTOPERATION_H


#include "receiptdataclasses.h"
#include <optional>
#include <QSharedPointer>

class SimpleReceiptOperation
{
public:
    SimpleReceiptOperation()noexcept;
    SimpleReceiptOperation(const SimpleReceiptOperation &other) noexcept;
    SimpleReceiptOperation(SimpleReceiptOperation &&other) noexcept;
    explicit SimpleReceiptOperation(const QVariantMap &map) noexcept;
    virtual ~SimpleReceiptOperation();


    virtual bool isValid() const;
    virtual bool isValid(CoreApiConst::ErrorCode &err, QString &msg) const;


    const FixNumber &quantity() const;
    void setQuantity(const FixNumber &newQuantity);

    const QString &name() const;
    void setName(const QString &newName);

    FixNumber cost() const;
    FixNumber calcCost() const;

    void setCost(std::optional<FixNumber> newCost);
    void setCost(const FixNumber & newCost);

    virtual bool hasPrice() const;
    virtual FixNumber price() const;
    virtual void setPrice(std::optional<FixNumber> newPrice);
    virtual void setPrice(const FixNumber &newPrice);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    FixNumber priceVat() const;
    void setPriceVat(std::optional<FixNumber> newPriceVat);

    fdf::VatRate vatRate() const;
    void setVatRate(fdf::VatRate newVatRate);

    FixNumber costVat() const;
    void setCostVat(std::optional<FixNumber> newCostRate);
    QString printedCostVat() const;

    fdf::ReceiptOperationType type() const;
    void setType(fdf::ReceiptOperationType newType);

    fdf::ItemPaymentType paymentType() const;
    void setPaymentType(fdf::ItemPaymentType newPaymentType);

    fdf::ItemPayAgentFlag agentFlag() const;
    void setAgentFlag(fdf::ItemPayAgentFlag newAgentFlag);

    std::optional<AgentData> agentData() const;
    void setAgentData(std::optional<AgentData> newAgentData);

    std::optional<ProviderData> providerData() const;
    void setProviderData(std::optional<ProviderData> newProviderData);

    const QString &providerInn() const;
    void setProviderInn(const QString &newProviderInn);

    std::optional<FixNumber> exciseTax() const;
    void setExciseTax(std::optional<FixNumber> newExciseTax);

    const QString &countryCode() const;
    void setCountryCode(const QString &newCountryCode);

    const QString &declarationNumber() const;
    void setDeclarationNumber(const QString &newDeclarationNumber);

    virtual fdf::ItemUnit unit() const;
    void setUnit(fdf::ItemUnit newUnit);

    std::optional<ProductCode> code() const;
    void setCode(std::optional<ProductCode> newCode);

    QList<IndustryProperty> industryProperties() const;
    void setIndustryProperties(const QList<IndustryProperty> &newIndustryProperties);

    virtual QVariantMap toMap() const;
    virtual QVariantMap toExternalMap() const;
    virtual void parseMap(const QVariantMap &map, CoreApiConst::ErrorCode *err = nullptr);

    virtual Tlv to1059() const;
    virtual void parseTlv(const Tlv::Stlv &list);
    virtual void clean();

    virtual void addQuantity();
    virtual void subQuantity();


    SimpleReceiptOperation &operator =(const SimpleReceiptOperation &other) noexcept;
    SimpleReceiptOperation &operator =(SimpleReceiptOperation &&other) noexcept;
    bool operator ==(const SimpleReceiptOperation &other) const noexcept;
    bool operator !=(const SimpleReceiptOperation &other) const noexcept;


protected:
    FixNumber quantity_;
    QString name_;
    std::optional<FixNumber> cost_;
    std::optional<FixNumber> price_;       //Цена позиции
    QString additionalParam_;
    std::optional<FixNumber> priceVat_;
    fdf::VatRate vatRate_;
    std::optional<FixNumber> costVat_;
    fdf::ReceiptOperationType type_;
    fdf::ItemPaymentType paymentType_;
    fdf::ItemPayAgentFlag agentFlag_;
    std::optional<AgentData> agentData_;
    std::optional<ProviderData> providerData_;
    QString providerInn_;
    std::optional<FixNumber> exciseTax_;
    QString countryCode_;
    QString declarationNumber_;
    fdf::ItemUnit unit_;
    std::optional<ProductCode> code_; //18) Реквизит "код товара" (тег 1163) включается в состав кассового чека при возврате или продаже товара, содержащего штриховой код с кодом товара и не включается в состав кассового чека в иных случаях.
    QList<IndustryProperty> industryProperties_;



    virtual bool checkPriceAndCost(CoreApiConst::ErrorCode &err, QString &msg) const;
    virtual bool checkAgent(CoreApiConst::ErrorCode &err, QString &msg) const;
    virtual bool checkCountry(CoreApiConst::ErrorCode &err, QString &msg) const;
    virtual bool checkIndustryCode(CoreApiConst::ErrorCode &err, QString &msg) const;

    virtual void parseChildTlv(const Tlv &tlv);

};
typedef QList<SimpleReceiptOperation> SimpleReceiptOperations;
typedef QSharedPointer<SimpleReceiptOperation> PSimpleReceiptOperation;
typedef QList<PSimpleReceiptOperation> PSimpleReceiptOperations;

#endif // SIMPLERECEIPTOPERATION_H
