#ifndef TAX_H
#define TAX_H

#include "fdfconstants.h"
#include "fixnumber.h"
#include "tlv.h"


class Tax
{
public:
    using TaxRate = fdf::VatRate;
    explicit Tax(TaxRate rate);
    explicit Tax(const Tlv &tag);
    Tax(const Tax &other);
    Tax(Tax &&other);
    ~Tax();

    quint32 rateValue() const; //ставка в процентах для FixNumber.
    TaxRate rate() const;
    void setRate(const TaxRate &rate);


    FixNumber operator()(const FixNumber &sum) const;
    Tlv receiptProperty(FixNumber *const value = nullptr) const;
    Tlv reportsProperty(FixNumber *const value = nullptr) const;
    QString caption() const;

    Tax &operator =(const Tax &other);
    Tax &operator =(Tax &&other);
    bool operator == (const Tax &other) const;
    bool operator != (const Tax &other) const;

    operator bool () const;

private:
    TaxRate rate_;
    fdf::Tag receiptTag() const;
    fdf::Tag reportsTag() const;
};


#endif // TAX_H
