#ifndef SESSIONDATA_H
#define SESSIONDATA_H

#include <QVariantMap>
#include <QString>
#include <QHash>

namespace umka365 {

class SupportedModels
{
    friend class SessionData;
public:
    SupportedModels() noexcept;
    SupportedModels(const SupportedModels &other) noexcept;
    SupportedModels(SupportedModels &&other) noexcept;
    ~SupportedModels();

    QString operator[](quint16 model) const;
    quint16 operator[](const QString &name) const;

    bool isSupported(quint16 model) const;
    bool isSupported(const QString &name) const;

    QHash<quint16, QString> models() const;


    SupportedModels &operator =(const SupportedModels &other) noexcept;
    SupportedModels &operator =(SupportedModels &&other) noexcept;
    bool operator ==(const SupportedModels &other) const noexcept;
    bool operator !=(const SupportedModels &other) const noexcept;

private:
    QHash<quint16, QString> byModel_;
    QHash<QString, quint16> byName_;

    explicit SupportedModels(const QVariantList &data);
};
//--------------------------------------------------------------------------------
class SessionData
{
public:
    SessionData();
    SessionData(const SessionData &other);
    SessionData(SessionData &&other);
    ~SessionData();

    bool isValid() const;

    qint64 dealerId() const;
    QString dealerName() const;
    bool dealerIsBlocked() const;
    qint16 userId() const;
    QString userName() const;
    bool userIsBlocked() const;
    QString sessionId() const;

    SupportedModels models() const;
    QHash<quint16, QString> supportedModels() const;

    bool parseData(const QByteArray &data);
    QByteArray hardwareRequestBody() const;
    QVariantMap toMap() const;

    void cleanSession();
    void cleanHardware();
    void clean();

    SessionData &operator =(const SessionData &other) noexcept;
    SessionData &operator =(SessionData &&other) noexcept;
    bool operator ==(const SessionData &other) const noexcept;
    bool operator !=(const SessionData &other) const noexcept;

private:
    QVariantMap sessionData_;
    QVariantList hardwareData_;
    SupportedModels models_;
};

}

#endif // SESSIONDATA_H
