#ifndef BASEDOC_H
#define BASEDOC_H

#include "fdfconstants.h"
#include "tlv.h"
#include "fsfullstatus.h"
#include "regdata.h"
#include "coretransaction.h"
#include <QObject>
#include <QDateTime>

class BaseDoc : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseDoc)

public:
    ~BaseDoc() override;

    QString docName() const;
    QString docShortName() const;


    fdf::DocType type() const;
    void setType(fdf::DocType newType);

    qint32 fd() const;
    void setFd(qint32 newFd);

    quint32 fiscalCode() const;
    void setFiscalCode(quint32 newFiscalCode);

    const QDateTime &dt() const;
    void setDt(const QDateTime &newDt);

    const QString &fsNumber() const;
    void setFsNumber(const QString &newFsNumber);

    bool isCopy() const;
    void setIsCopy(bool newIsCopy);

    const QString &externalId() const;
    void setExternalId(const QString &newExternalId);

    const QString &clientId() const;
    void setClientId(const QString &newClientId);

    void setDataFromTask(const CoreTransaction &task);


    virtual void  parseFromTlvList(const Tlv::Stlv &list, bool clear = false);
    virtual void clean();
    virtual QVariantMap toMap() const;
    virtual QVariantMap toExternalMap() const;
    virtual void parseMap(const QVariantMap &map);

protected:
    fdf::DocType type_;
    qint32 fd_;
    quint32 fiscalCode_;
    QDateTime dt_;
    QString fsNumber_;
    bool isCopy_;
    QString externalId_;
    QString clientId_;


    explicit BaseDoc(fdf::DocType docType, QObject *parent = nullptr);
    virtual void parseFromTlv(const Tlv &tlv);
    virtual bool jsonToVariant(const QString &json, QVariant &v);
};


//--------------------------------------------------------------------------------------------------

class BaseWorkDoc: public BaseDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseWorkDoc)
public:
    ~BaseWorkDoc() override;


    fs::FFD ffd() const;
    void setFfd(fs::FFD newFfd);

    quint16 cycle() const;
    void setCycle(quint16 newCycle);

    const QString &address() const;
    void setAddress(const QString &newAddress);

    const QString &ownerInn() const;
    void setOwnerInn(const QString &newUserInn);

    const QString &regNumber() const;
    void setRegNumber(const QString &newRegNumber);

    const QString &ownerName() const;
    void setOwnerName(const QString &newUserName);

    const QString &place() const;
    void setPlace(const QString &newPlace);


    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    virtual void setRegData(const RegData &rd, bool replace = false);




protected:
    fs::FFD ffd_;
    quint16 cycle_;
    QString address_;
    QString ownerInn_;
    QString regNumber_;
    QString ownerName_;
    QString place_;


    explicit BaseWorkDoc(fdf::DocType type, QObject *parent = nullptr);
    void parseFromTlv(const Tlv &tlv) override;

};

//--------------------------------------------------------------------------------------------------

class BaseWorkIncoming
{
public:
    BaseWorkIncoming()noexcept;
    explicit BaseWorkIncoming(const QVariantMap &map)noexcept;
    BaseWorkIncoming(const BaseWorkIncoming &other)noexcept;
    BaseWorkIncoming(BaseWorkIncoming &&other)noexcept;
    virtual ~BaseWorkIncoming();

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalData() const;
    void setAdditionalData(const QByteArray &newAdditionalData);

    const QString &ownerName() const;
    void setOwnerName(const QString &newUserName);

    const QString &address() const;
    void setAddress(const QString &newAddress);

    const QString &place() const;
    void setPlace(const QString &newPlace);

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);

    virtual void clean();

    BaseWorkIncoming &operator =(const BaseWorkIncoming &other) noexcept;
    BaseWorkIncoming &operator =(BaseWorkIncoming &&other) noexcept;
    bool operator ==(const BaseWorkIncoming &other) const noexcept;
    bool operator !=(const BaseWorkIncoming &other) const noexcept;

protected:
    QString cashier_;
    QString cashierInn_;
    QString additionalParam_;
    QByteArray additionalData_;
    QString ownerName_;
    QString address_;
    QString place_;
};

#endif // BASEDOC_H
