#include "calcreportdoc.h"
#include "formatutils.h"


#include <QJsonDocument>

CalcReportDoc::CalcReportDoc(QObject *parent)
    : BaseWorkDoc(fdf::DocType::CalcReport, parent)
    , offlineMode_(false)
    , notSendedDocs_(0)
    , firstNotSended_(0)
    , notSendedNotifications_(0)
    , keysResource_(0)
    , firstNotSendedDocDt_()
    , additionalParam_()
    , additionalData_()
    , fsCounters_()
    , notSendedCounters_()
{

}

CalcReportDoc::~CalcReportDoc()
{

}

bool CalcReportDoc::offlineMode() const
{
    return offlineMode_;
}

void CalcReportDoc::setOfflineMode(bool newOfflineMode)
{
    offlineMode_ = newOfflineMode;
}

quint32 CalcReportDoc::notSendedDocs() const
{
    return notSendedDocs_;
}

void CalcReportDoc::setNotSendedDocs(quint32 newNotSendedDocs)
{
    notSendedDocs_ = newNotSendedDocs;
}

quint32 CalcReportDoc::firstNotSended() const
{
    return firstNotSended_;
}

void CalcReportDoc::setFirstNotSended(quint32 newFirstNotSended)
{
    firstNotSended_ = newFirstNotSended;
}

quint32 CalcReportDoc::notSendedNotifications() const
{
    return notSendedNotifications_;
}

void CalcReportDoc::setNotSendedNotifications(quint32 newNotSendedNotifications)
{
    notSendedNotifications_ = newNotSendedNotifications;
}

quint16 CalcReportDoc::keysResource() const
{
    return keysResource_;
}

void CalcReportDoc::setKeysResource(quint16 newKeysResource)
{
    keysResource_ = newKeysResource;
}

const QDate &CalcReportDoc::firstNotSendedDocDt() const
{
    return firstNotSendedDocDt_;
}

void CalcReportDoc::setFirstNotSendedDocDt(const QDate &newFirstNotSendedDocDt)
{
    firstNotSendedDocDt_ = newFirstNotSendedDocDt;
}

const QString &CalcReportDoc::additionalParam() const
{
    return additionalParam_;
}

void CalcReportDoc::setAdditionalParam(const QString &newAdditionalParam)
{
    additionalParam_ = newAdditionalParam;
}

const QByteArray &CalcReportDoc::additionalData() const
{
    return additionalData_;
}

void CalcReportDoc::setAdditionalData(const QByteArray &newAdditionalData)
{
    additionalData_ = newAdditionalData;
}

const TaggedFsCounters &CalcReportDoc::fsCounters() const
{
    return fsCounters_;
}

void CalcReportDoc::setFsCounters(const TaggedFsCounters &newFsCounters)
{
    fsCounters_ = newFsCounters;
}

const ShortTaggedFsCounters &CalcReportDoc::notSendedCounters() const
{
    return notSendedCounters_;
}

void CalcReportDoc::setNotSendedCounters(const ShortTaggedFsCounters &newNotSendedCounters)
{
    notSendedCounters_ = newNotSendedCounters;
}

void CalcReportDoc::setIncoming(const CalcReportIncoming &inc, bool replace)
{
    if(replace || additionalParam_.isEmpty()) additionalParam_    =  inc.additionalParam();
    if(replace || additionalData_ .isEmpty()) additionalData_     = inc.additionalData();
    if(replace || ownerName_      .isEmpty()) ownerName_           = inc.ownerName();
    if(replace || address_        .isEmpty()) address_            = inc.address();
    if(replace || place_          .isEmpty()) place_              = inc.place();
}

void CalcReportDoc::clean()
{
    offlineMode_ = false;
    notSendedDocs_ = 0;
    firstNotSended_ = 0;
    notSendedNotifications_ = 0;
    keysResource_ = 0;
    firstNotSendedDocDt_ = QDate();
    additionalParam_.clear();
    additionalData_.clear();
    fsCounters_.clean();
    notSendedCounters_.clean();
}

QVariantMap CalcReportDoc::toMap() const
{
    QVariantMap res {
        {"offlineMode", offlineMode_ ? 1 : 0},
        {"notSendedDocs", notSendedDocs_},
        {"firstNotSendedDoc", firstNotSended_},
        {"notSendedNotifications", notSendedNotifications_},
        {"keysResource",        keysResource_},
        {"firstNotSendedDocDt", firstNotSendedDocDt_.toString(Qt::ISODate)},
        {"additionalParam",additionalParam_ },
        {"additionalData", QString::fromLatin1(additionalData_.toHex())  },
        {"fsCounters", fsCounters_.toMap()},
        {"notSendedCounters", notSendedCounters_.toMap()}
    };
    res = UNIT_MAPS(BaseWorkDoc::toMap(), res);
    return res;
}

QVariantMap CalcReportDoc::toExternalMap() const
{
    QVariantMap res {
        {"offlineMode", offlineMode_ ? 1 : 0},
        {"notSendedDocs", notSendedDocs_},
        {"firstNotSendedDoc", firstNotSended_},
        {"notSendedNotifications", notSendedNotifications_},
        {"keysResource",        keysResource_},
        {"firstNotSendedDocDt", firstNotSendedDocDt_.isValid() ?
                            QVariant( firstNotSendedDocDt_.toString(Qt::ISODate)) : QVariant()},
        {"additionalParam",additionalParam_.isEmpty() ? QVariant() : QVariant(additionalParam_) },
        {"additionalData", additionalData_ .isEmpty() ? QVariant() :
                                                        QVariant(QString::fromLatin1(additionalData_.toHex()) ) },
        {"fsCounters", fsCounters_.toExternalMap()},
        {"notSendedCounters", notSendedCounters_.toExternalMap()}

    };
    res = UNIT_MAPS(BaseWorkDoc::toExternalMap(), res);
    return res;
}

void CalcReportDoc::parseMap(const QVariantMap &map)
{
    clean();

    BaseWorkDoc::parseMap(map);
    offlineMode_ = map.contains("offlineMode") && map["offlineMode"].toBool();
    notSendedDocs_  = map["notSendedDocs"].toUInt();
    firstNotSended_ = map["firstNotSendedDoc"].toUInt();
    notSendedNotifications_  = map["notSendedNotifications"].toUInt();
    keysResource_  = map["keysResource"].toUInt();
    firstNotSendedDocDt_ = QDate::fromString(map["firstNotSendedDocDt"].toString(), Qt::ISODate);
    additionalParam_= map["additionalParam"].toString();
    additionalData_ = QByteArray::fromHex(map["additionalData"].toString().toLatin1());
    fsCounters_.parseMap(map["fsCounters"].toMap());
    notSendedCounters_.parseMap(map["notSendedCounters"].toMap());
}

void CalcReportDoc::setRegData(const RegData &rd, bool replace)
{
    BaseWorkDoc::setRegData(rd, replace);
}




void CalcReportDoc::parseFromTlv(const Tlv &tlv)
{
    switch (tlv.tag())
    {
    case fdf::Tag::OfflineMode: offlineMode_ = tlv.toBool();break;
    case fdf::Tag::NotSendedDocsCount: notSendedDocs_ = tlv.toUInt32();break;
    case fdf::Tag::FirstNotSendedFd: firstNotSended_ = tlv.toUInt32();break;
    case fdf::Tag::NotSendedNotificationsCount: notSendedNotifications_ = tlv.toUInt32();break;
    case fdf::Tag::KeysResource: keysResource_ = tlv.toUInt16();break;
    case fdf::Tag::FirstNotSendedDt: firstNotSendedDocDt_ = tlv.toDate();break;
    case fdf::Tag::CalReportAdditionalParam: additionalParam_ = tlv.toString().trimmed();break;
    case fdf::Tag::CalcReportAdditionalData: additionalData_ = tlv.value();break;
    case fdf::Tag::FsTotalsCounters: fsCounters_.parseTlv(tlv);break;
    case fdf::Tag::FsNotSendedTotalsCounters: notSendedCounters_.parseTlv(tlv);break;
    default: BaseWorkDoc::parseFromTlv(tlv);
    }
}

//--------------------------------------------------------------------------------------------------

CalcReportIncoming::CalcReportIncoming() noexcept
    : BaseWorkIncoming()
{

}

CalcReportIncoming::CalcReportIncoming(const QVariantMap &map) noexcept
    : BaseWorkIncoming(map)
{

}

CalcReportIncoming::CalcReportIncoming(const CalcReportIncoming &other) noexcept
    : BaseWorkIncoming(other)
{

}

CalcReportIncoming::CalcReportIncoming(CalcReportIncoming &&other) noexcept
    : BaseWorkIncoming(other)
{

}

CalcReportIncoming::~CalcReportIncoming()
{

}

Tlv::Stlv CalcReportIncoming::tlv(const RegData &rd) const
{
    Q_UNUSED(rd)
    Tlv::Stlv res;
    Tlv buf;
    if(!additionalParam_.isEmpty())
    {
        buf.setString(fdf::Tag::CalReportAdditionalParam, additionalParam_);
        res << buf;
    }
    if(!additionalData_.isEmpty())
    {
        buf.setTag(fdf::Tag::CalcReportAdditionalData);
        buf.setValue(additionalData_);
        res << buf;
    }
    if(!address_.isEmpty() && address_ != rd.address())
    {
        buf.setString(fdf::Tag::Address, address_);
        res << buf;
    }
    if(!place_.isEmpty() && place_ != rd.place())
    {
        buf.setString(fdf::Tag::Place, place_);
        res << buf;
    }
    return res;
}

CalcReportIncoming &CalcReportIncoming::operator =(const CalcReportIncoming &other) noexcept
{
    BaseWorkIncoming::operator =(other);
    return *this;
}
CalcReportIncoming &CalcReportIncoming::operator =(CalcReportIncoming &&other) noexcept
{
    BaseWorkIncoming::operator =(other);
    return *this;
}

bool CalcReportIncoming::operator ==(const CalcReportIncoming &other) const noexcept
{
    return BaseWorkIncoming::operator ==(other);
}

bool CalcReportIncoming::operator !=(const CalcReportIncoming &other) const noexcept
{
    return !(*this == other);
}
