#ifndef CALCREPORTDOC_H
#define CALCREPORTDOC_H

#include "basedoc.h"
#include "fsfullstatus.h"
#include "fdfconstants.h"
#include "regdata.h"
#include "fscounters.h"

class CalcReportIncoming: public BaseWorkIncoming
{
public:
    CalcReportIncoming()noexcept;
    explicit CalcReportIncoming(const QVariantMap &map)noexcept;
    CalcReportIncoming(const CalcReportIncoming &other)noexcept;
    CalcReportIncoming(CalcReportIncoming &&other)noexcept;
    ~CalcReportIncoming() override;

    Tlv::Stlv tlv(const RegData &rd) const;

    CalcReportIncoming &operator =(const CalcReportIncoming &other) noexcept;
    CalcReportIncoming &operator =(CalcReportIncoming &&other) noexcept;
    bool operator ==(const CalcReportIncoming &other) const noexcept;
    bool operator !=(const CalcReportIncoming &other) const noexcept;

};
//--------------------------------------------------------------------------------------------------
class CalcReportDoc : public BaseWorkDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(CalcReportDoc)
public:
    explicit CalcReportDoc(QObject *parent = nullptr);
    ~CalcReportDoc() override;

    bool offlineMode() const;
    void setOfflineMode(bool newOfflineMode);

    quint32 notSendedDocs() const;
    void setNotSendedDocs(quint32 newNotSendedDocs);

    quint32 firstNotSended() const;
    void setFirstNotSended(quint32 newFirstNotSended);

    quint32 notSendedNotifications() const;
    void setNotSendedNotifications(quint32 newNotSendedNotifications);

    quint16 keysResource() const;
    void setKeysResource(quint16 newKeysResource);

    const QDate &firstNotSendedDocDt() const;
    void setFirstNotSendedDocDt(const QDate &newFirstNotSendedDocDt);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalData() const;
    void setAdditionalData(const QByteArray &newAdditionalData);

    const TaggedFsCounters &fsCounters() const;
    void setFsCounters(const TaggedFsCounters &newFsCounters);

    const ShortTaggedFsCounters &notSendedCounters() const;
    void setNotSendedCounters(const ShortTaggedFsCounters &newNotSendedCounters);

    void setIncoming(const CalcReportIncoming &inc, bool replace = false);

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setRegData(const RegData &rd, bool replace = false) override;

private:
    bool offlineMode_;
    quint32 notSendedDocs_;
    quint32 firstNotSended_;
    quint32 notSendedNotifications_;
    quint16 keysResource_;
    QDate firstNotSendedDocDt_;
    QString additionalParam_;
    QByteArray additionalData_;
    TaggedFsCounters fsCounters_;
    ShortTaggedFsCounters notSendedCounters_;

    void parseFromTlv(const Tlv &tlv) override;
};

#endif // CALCREPORTDOC_H
