#ifndef CYCLECLOSEDOC_H
#define CYCLECLOSEDOC_H

#include "basedoc.h"
#include "fsfullstatus.h"
#include "fdfconstants.h"
#include "regdata.h"
#include "fscounters.h"


class CycleCloseIncoming: public BaseWorkIncoming
{
public:
    CycleCloseIncoming()noexcept;
    explicit CycleCloseIncoming(const QVariantMap &map)noexcept;
    CycleCloseIncoming(const CycleCloseIncoming &other)noexcept;
    CycleCloseIncoming(CycleCloseIncoming &&other)noexcept;
    ~CycleCloseIncoming()  override;

    Tlv::Stlv tlv(const RegData &rd, const fdf::IncorrectLabelsFlags &ilf,
                  const fdf::IncorrectNotificationsFlags &inf) const;

    CycleCloseIncoming &operator =(const CycleCloseIncoming &other) noexcept;
    CycleCloseIncoming &operator =(CycleCloseIncoming &&other) noexcept;
    bool operator ==(const CycleCloseIncoming &other) const noexcept;
    bool operator !=(const CycleCloseIncoming &other) const noexcept;

};

//--------------------------------------------------------------------------------------------------

class CycleCloseDoc: public BaseWorkDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(CycleCloseDoc)
public:
    explicit CycleCloseDoc(QObject *parent = nullptr);
    ~CycleCloseDoc() override;

    const fs::Warnings &warnings() const;
    void setWarnings(const fs::Warnings &newWarnings);

    const fdf::OfdWarnings &ofdWarnings() const;
    void setOfdWarnings(const fdf::OfdWarnings &newOfdWarnings);

    const fdf::IncorrectLabelsFlags &incorrectLabelsFlags() const;
    void setIncorrectLabelsFlags(const fdf::IncorrectLabelsFlags &newIncorrectLabelsFlags);

    const fdf::IncorrectNotificationsFlags &incorrectNotificationsFlags() const;
    void setIncorrectNotificationsFlags(const fdf::IncorrectNotificationsFlags &newIncorrectNotificationsFlags);

    quint32 documentsCount() const;
    void setDocumentsCount(quint32 newDoucumentsCount);

    quint32 receiptsCount() const;
    void setReceiptsCount(quint32 newReceiptsCount);

    quint32 notSendedDocs() const;
    void setNotSendedDocs(quint32 newNotSendedDocs);

    quint32 notSendedNotifications() const;
    void setNotSendedNotifications(quint32 newNotSendedNotifications);

    quint16 keysResource() const;
    void setKeysResource(quint16 newKeysResource);

    const QDate &firstNotSendedDocDt() const;
    void setFirstNotSendedDocDt(const QDate &newFirstNotSendedDocDt);

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalData() const;
    void setAdditionalData(const QByteArray &newAdditionalData);

    const TaggedFsCounters &fsCounters() const;
    void setFsCounters(const TaggedFsCounters &newFsCounters);

    const TaggedFsCounters &cycleCounters() const;
    void setCycleCounters(const TaggedFsCounters &newCycleCounters);

    void setIncoming(const CycleCloseIncoming &inc, bool replace = false);

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setRegData(const RegData &rd, bool replace = false) override;

private:
    fs::Warnings warnings_;
    fdf::OfdWarnings ofdWarnings_;
    //TODO. Эти флаги заполняются руками. хранятся в вотчере

    fdf::IncorrectLabelsFlags incorrectLabelsFlags_;
    fdf::IncorrectNotificationsFlags incorrectNotificationsFlags_;
    quint32 documentsCount_;
    quint32 receiptsCount_;
    quint32 notSendedDocs_;
    quint32 notSendedNotifications_;
    quint16 keysResource_;
    QDate firstNotSendedDocDt_;

    QString cashier_;
    QString cashierInn_;
    QString additionalParam_;
    QByteArray additionalData_;

    TaggedFsCounters fsCounters_;
    TaggedFsCounters cycleCounters_;

    void parseFromTlv(const Tlv &tlv) override;
};

#endif // CYCLECLOSEDOC_H
