#ifndef CYCLEOPENDOC_H
#define CYCLEOPENDOC_H

#include "basedoc.h"
#include "fsfullstatus.h"
#include "fdfconstants.h"
#include "regdata.h"


class CycleOpenIncoming :public BaseWorkIncoming
{
public:
    CycleOpenIncoming()noexcept;
    explicit CycleOpenIncoming(const QVariantMap &map)noexcept;
    CycleOpenIncoming(const CycleOpenIncoming &other)noexcept;
    CycleOpenIncoming(CycleOpenIncoming &&other)noexcept;
    ~CycleOpenIncoming() override;

    Tlv::Stlv tlv(const RegData &rd) const;

    CycleOpenIncoming &operator =(const CycleOpenIncoming &other) noexcept;
    CycleOpenIncoming &operator =(CycleOpenIncoming &&other) noexcept;
    bool operator ==(const CycleOpenIncoming &other) const noexcept;
    bool operator !=(const CycleOpenIncoming &other) const noexcept;



};

//--------------------------------------------------------------------------------------------------


class CycleOpenDoc : public BaseWorkDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(CycleOpenDoc)
public:
    explicit CycleOpenDoc(QObject *parent = nullptr);
    ~CycleOpenDoc() override;

    const fs::Warnings &warnings() const;
    void setWarnings(const fs::Warnings &newWarnings);

    fs::FFD cashboxFFD() const;
    void setCashboxFFD(fs::FFD newCashboxFFD);

    const fdf::OfdWarnings &ofdWarnings() const;
    void setOfdWarnings(const fdf::OfdWarnings &newOfdWarnings);

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &cashboxVersion() const;
    void setCashboxVersion(const QString &newCashboxVersion);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalData() const;
    void setAdditionalData(const QByteArray &newAdditionalData);

    QString updateKeysText() const;
    void setUpdateKeysText(const QString &newUpdateKeysText);

    void setIncoming(const CycleOpenIncoming &inc, bool replace = false);

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setRegData(const RegData &rd, bool replace = false) override;

private:
    fs::Warnings warnings_;
    fs::FFD cashboxFFD_;
    fdf::OfdWarnings ofdWarnings_;
    QString cashier_;
    QString cashboxVersion_;
    QString cashierInn_;
    QString additionalParam_;
    QByteArray additionalData_;
    QString updateKeysText_;

    void parseFromTlv(const Tlv &tlv) override;
};

#endif // CYCLEOPENDOC_H
