#ifndef FSCLOSEDOC_H
#define FSCLOSEDOC_H


#include "basedoc.h"
#include "fsfullstatus.h"
#include "fdfconstants.h"
#include "regdata.h"
#include "fscounters.h"

class FsCloseIncoming: public BaseWorkIncoming
{
public:
    FsCloseIncoming()noexcept;
    explicit FsCloseIncoming(const QVariantMap &map)noexcept;
    FsCloseIncoming(const FsCloseIncoming &other)noexcept;
    FsCloseIncoming(FsCloseIncoming &&other)noexcept;
    ~FsCloseIncoming()  override;

    Tlv::Stlv tlv(const RegData &rd) const;

    FsCloseIncoming &operator =(const FsCloseIncoming &other) noexcept;
    FsCloseIncoming &operator =(FsCloseIncoming &&other) noexcept;
    bool operator ==(const FsCloseIncoming &other) const noexcept;
    bool operator !=(const FsCloseIncoming &other) const noexcept;

};
//--------------------------------------------------------------------------------------------------

class FsCloseDoc : public BaseWorkDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(FsCloseDoc)
public:
    explicit FsCloseDoc(QObject *parent = nullptr);
    ~FsCloseDoc() override;

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalData() const;
    void setAdditionalData(const QByteArray &newAdditionalData);

    const TaggedFsCounters &fsCounters() const;
    void setFsCounters(const TaggedFsCounters &newFsCounters);


    void setIncoming(const FsCloseIncoming &inc, bool replace = false);


    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setRegData(const RegData &rd, bool replace = false) override;

private:
    QString cashier_;
    QString cashierInn_;
    QString additionalParam_;
    QByteArray additionalData_;
    TaggedFsCounters fsCounters_;

    void parseFromTlv(const Tlv &tlv) override;
};

#endif // FSCLOSEDOC_H
