#include "receiptdoc.h"
#include "formatutils.h"
#include "cashboxbuildconfig.h"


#include <QJsonDocument>

BaseReceiptDoc::~BaseReceiptDoc()
{

}

quint16 BaseReceiptDoc::receiptNumber() const
{
    return receiptNumber_;
}

void BaseReceiptDoc::setReceiptNumber(quint16 newReceiptNumber)
{
    receiptNumber_ = newReceiptNumber;
}

fdf::PaymentType BaseReceiptDoc::paymentAttr() const
{
    return paymentAttr_;
}

void BaseReceiptDoc::setPaymentAttr(fdf::PaymentType newPaymentAttr)
{
    paymentAttr_ = newPaymentAttr;
}

fdf::Tax BaseReceiptDoc::tax() const
{
    return tax_;
}

void BaseReceiptDoc::setTax(fdf::Tax newTax)
{
    tax_ = newTax;
}

FixNumber BaseReceiptDoc::amount() const
{
    return amount_;
}

void BaseReceiptDoc::setAmount(const FixNumber &newAmount)
{
    amount_ = newAmount;
}
std::optional<FixNumber> BaseReceiptDoc::change() const
{
    return change_;
}

void BaseReceiptDoc::setChange(std::optional<FixNumber> newChange)
{
    change_ = newChange;
}
std::optional<FixNumber> BaseReceiptDoc::cash() const
{
    return cash_;
}

void BaseReceiptDoc::setCash(std::optional<FixNumber> newCash)
{
    cash_ = newCash;
}

std::optional<FixNumber> BaseReceiptDoc::card() const
{
    return card_;
}

void BaseReceiptDoc::setCard(std::optional<FixNumber> newCard)
{
    card_ = newCard;
}

std::optional<FixNumber> BaseReceiptDoc::prepay() const
{
    return prepay_;
}

void BaseReceiptDoc::setPrepay(std::optional<FixNumber> newPrepay)
{
    prepay_ = newPrepay;
}

std::optional<FixNumber> BaseReceiptDoc::postpay() const
{
    return postpay_;
}

void BaseReceiptDoc::setPostpay(std::optional<FixNumber> newPostpay)
{
    postpay_ = newPostpay;
}

std::optional<FixNumber> BaseReceiptDoc::barter() const
{
    return barter_;
}

void BaseReceiptDoc::setBarter(std::optional<FixNumber> newBarter)
{
    barter_ = newBarter;
}

std::optional<FixNumber> BaseReceiptDoc::vat20() const
{
    return vat20_;
}

void BaseReceiptDoc::setVat20(std::optional<FixNumber> newVat20)
{
    vat20_ = newVat20;
}

std::optional<FixNumber> BaseReceiptDoc::vat10() const
{
    return vat10_;
}

void BaseReceiptDoc::setVat10(std::optional<FixNumber> newVat10)
{
    vat10_ = newVat10;
}

std::optional<FixNumber> BaseReceiptDoc::vat0() const
{
    return vat0_;
}

void BaseReceiptDoc::setVat0(std::optional<FixNumber> newVat0)
{
    vat0_ = newVat0;
}

std::optional<FixNumber> BaseReceiptDoc::vatNone() const
{
    return vatNone_;
}

void BaseReceiptDoc::setVatNone(std::optional<FixNumber> newVatNone)
{
    vatNone_ = newVatNone;
}

std::optional<FixNumber> BaseReceiptDoc::vat20_120() const
{
    return vat20_120_;
}

void BaseReceiptDoc::setVat20_120(std::optional<FixNumber> newVat20_120)
{
    vat20_120_ = newVat20_120;
}

std::optional<FixNumber> BaseReceiptDoc::vat10_110() const
{
    return vat10_110_;
}

void BaseReceiptDoc::setVat10_110(std::optional<FixNumber> newVat10_110)
{
    vat10_110_ = newVat10_110;
}

std::optional<FixNumber> BaseReceiptDoc::vat5() const
{
    return vat5_;
}

void BaseReceiptDoc::setVat5(std::optional<FixNumber> newVat5)
{
    vat5_ = newVat5;
}

std::optional<FixNumber> BaseReceiptDoc::vat7() const
{
    return vat7_;
}

void BaseReceiptDoc::setVat7(std::optional<FixNumber> newVat7)
{
    vat7_ = newVat7;
}

std::optional<FixNumber> BaseReceiptDoc::vat5_105() const
{
    return vat5_105_;
}

void BaseReceiptDoc::setVat5_105(std::optional<FixNumber> newVat5_105)
{
    vat5_105_ = newVat5_105;
}

std::optional<FixNumber> BaseReceiptDoc::vat7_107() const
{
    return vat7_107_;
}

void BaseReceiptDoc::setVat7_107(std::optional<FixNumber> newVat7_107)
{
    vat7_107_ = newVat7_107;
}



std::optional<ReceiptAdditionalUserParam> BaseReceiptDoc::userParam() const
{
    return userParam_;
}

void BaseReceiptDoc::setUserParam(std::optional<ReceiptAdditionalUserParam> newUserParam)
{
    userParam_ = newUserParam;
}

std::optional<BuyerInfo> BaseReceiptDoc::buyerInfo() const
{
    return buyerInfo_;
}

void BaseReceiptDoc::setBuyerInfo(std::optional<BuyerInfo> newBuyerInfo)
{
    buyerInfo_ = newBuyerInfo;
}

const QList<IndustryProperty> &BaseReceiptDoc::industryProperties() const
{
    return industryProperties_;
}

void BaseReceiptDoc::setIndustryProperties(const QList<IndustryProperty> &newIndustryProperties)
{
    industryProperties_ = newIndustryProperties;
}

std::optional<ReceiptOperationalParam> BaseReceiptDoc::operationalParam() const
{
    return operationalParam_;
}

void BaseReceiptDoc::setOperationalParam(std::optional<ReceiptOperationalParam> newOperationalParam)
{
    operationalParam_ = newOperationalParam;
}

const QString &BaseReceiptDoc::buyerPhone() const
{
    return buyerPhone_;
}

void BaseReceiptDoc::setBuyerPhone(const QString &newBuyerPhone)
{
    buyerPhone_ = newBuyerPhone;
}

const QString &BaseReceiptDoc::boxId() const
{
    return boxId_;
}

const QString &BaseReceiptDoc::fnsSite() const
{
    return fnsSite_;
}

void BaseReceiptDoc::setFnsSite(const QString &newFnsSite)
{
    fnsSite_ = newFnsSite;
}

const QString &BaseReceiptDoc::ownerEmail() const
{
    return ownerEmail_;
}

void BaseReceiptDoc::setOwnerEmail(const QString &newOwnerEmail)
{
    ownerEmail_ = newOwnerEmail;
}

const QString &BaseReceiptDoc::cashier() const
{
    return cashier_;
}

void BaseReceiptDoc::setCashier(const QString &newCashier)
{
    cashier_ = newCashier;
}

const QString &BaseReceiptDoc::cashierInn() const
{
    return cashierInn_;
}

void BaseReceiptDoc::setCashierInn(const QString &newCashierInn)
{
    cashierInn_ = newCashierInn;
}

const QString &BaseReceiptDoc::additionalParam() const
{
    return additionalParam_;
}

void BaseReceiptDoc::setAdditionalParam(const QString &newAdditionalParam)
{
    additionalParam_ = newAdditionalParam;
}
const PSimpleReceiptOperations &BaseReceiptDoc::operations() const
{
    return operations_;
}

void BaseReceiptDoc::setOperations(const PSimpleReceiptOperations &newOperations)
{
    operations_ = newOperations;
}

QString BaseReceiptDoc::qrText() const
{
    return QStringLiteral("t=%1&s=%2&fn=%3&i=%4&fp=%5&n=%6")
            .arg(dt_.toString("yyyyMMddThhmm"))
            .arg(amount().toString('.'))
            .arg(fsNumber().trimmed())
            .arg(fd())
            .arg(fiscalCode())
            .arg(static_cast<qint32>(paymentAttr()));
}

void BaseReceiptDoc::clean()
{
    BaseWorkDoc::clean();
    receiptNumber_ = 0;
    paymentAttr_ = fdf::PaymentType::Invalid;
    tax_ = fdf::Tax::Invalid;
    amount_ = FixNumber(DEFAULT_AMOUNT_MULT);
    change_.reset();
    cash_.reset();
    card_.reset();
    prepay_.reset();
    postpay_.reset();
    barter_.reset();
    vat20_.reset();
    vat10_.reset();
    vat0_.reset();
    vatNone_.reset();
    vat20_120_.reset();
    vat10_110_.reset();
    vat5_.reset();
    vat7_.reset();
    vat5_105_.reset();
    vat7_107_.reset();
    userParam_.reset();
    buyerInfo_.reset();
    industryProperties_.clear();
    operationalParam_.reset();
    buyerPhone_.clear();
    boxId_.clear();
    fnsSite_.clear();
    ownerEmail_.clear();
    cashier_.clear();
    cashierInn_.clear();
    additionalParam_.clear();
    operations_.clear();
    t2107_ = 255;
}

QVariantMap BaseReceiptDoc::toMap() const
{
    QVariantMap res = BaseWorkDoc::toMap();
    res["paymentAttr"] = static_cast<qint32>(paymentAttr_);
    res["tax"] = static_cast<qint32>(tax_);
    res["receipt"] = receiptNumber_;
    res["amount"]    = amount_   .toMap();
    if(change_   .has_value())res["change"]    = change_   .value().toMap();
    if(cash_     .has_value())res["cash"]      = cash_     .value().toMap();
    if(card_     .has_value())res["card"]      = card_     .value().toMap();
    if(prepay_   .has_value())res["prepay"]    = prepay_   .value().toMap();
    if(postpay_  .has_value())res["postpay"]   = postpay_  .value().toMap();
    if(barter_   .has_value())res["barter"]    = barter_   .value().toMap();
    if(vat20_    .has_value())res["vat20"]     = vat20_    .value().toMap();
    if(vat10_    .has_value())res["vat10"]     = vat10_    .value().toMap();
    if(vat0_     .has_value())res["vat0"]      = vat0_     .value().toMap();
    if(vatNone_  .has_value())res["vatNone"]   = vatNone_  .value().toMap();
    if(vat20_120_.has_value())res["vat20_120"] = vat20_120_.value().toMap();
    if(vat10_110_.has_value())res["vat10_110"] = vat10_110_.value().toMap();
    if(vat5_     .has_value())res["vat5"]      = vat5_     .value().toMap();
    if(vat7_     .has_value())res["vat7"]      = vat7_     .value().toMap();
    if(vat5_105_ .has_value())res["vat5_105"]  = vat5_105_ .value().toMap();
    if(vat7_107_ .has_value())res["vat7_107"]  = vat7_107_ .value().toMap();

    if(userParam_       .has_value())res["userParam"] = userParam_.value().toMap();
    if(buyerInfo_       .has_value())res["buyerInfo"] = buyerInfo_.value().toMap();
    if(operationalParam_.has_value())res["operationalParam"] = operationalParam_.value().toMap();
    if(!industryProperties_.isEmpty())
    {
        QVariantList list;
        for(const IndustryProperty &p :industryProperties_)
        {
            list << p.toMap();
        }
        res["industryProperties"] = list;
    }
    if(!buyerPhone_.isEmpty())res["buyerPhone"] = buyerPhone_;
    if(!boxId_     .isEmpty())res["boxId"]      = boxId_     ;
    if(!fnsSite_   .isEmpty())res["ftsSite"]    = fnsSite_   ;
    if(!ownerEmail_.isEmpty())res["ownerEmail"] = ownerEmail_;
    if(!operations_.isEmpty())
    {
        QVariantList list;
        QVariantList labledList;
        for(const PSimpleReceiptOperation &o :operations_)
        {
            if(o.dynamicCast<ReceiptOperation>()) labledList << o->toMap();
            else list << o->toMap();

        }
        if(!list.isEmpty())res["operations"] = list;
        if(!labledList.isEmpty())res["labledOperations"] = labledList;
    }
    if(t2107_ != 255)
    {
        res["labelsCheckResult"] = static_cast<qint32>(t2107_);
    }
    if(!cashier_.isEmpty()) res["cashier"] = cashier_;
    if(!cashierInn_.isEmpty()) res["cashierInn"] = cashierInn_;
    if(!additionalParam_.isEmpty()) res["additionalParam"] = additionalParam_ ;
    return res;
}

QVariantMap BaseReceiptDoc::toExternalMap() const
{
    QVariantMap res = BaseWorkDoc::toExternalMap();
    res["receipt"] = receiptNumber_;
    res["paymentAttr"] = static_cast<qint32>(paymentAttr_);
    res["tax"] = static_cast<qint32>(tax_);
    res["amount"]    = amount_   .toString();
    if(change_   .has_value())res["change"]    = change_   .value().toString();
    if(cash_     .has_value())res["cash"]      = cash_     .value().toString();
    if(card_     .has_value())res["card"]      = card_     .value().toString();
    if(prepay_   .has_value())res["prepay"]    = prepay_   .value().toString();
    if(postpay_  .has_value())res["postpay"]   = postpay_  .value().toString();
    if(barter_   .has_value())res["barter"]    = barter_   .value().toString();
    if(vat20_    .has_value())res["vat20"]     = vat20_    .value().toString();
    if(vat10_    .has_value())res["vat10"]     = vat10_    .value().toString();
    if(vat0_     .has_value())res["vat0"]      = vat0_     .value().toString();
    if(vatNone_  .has_value())res["vatNone"]   = vatNone_  .value().toString();
    if(vat20_120_.has_value())res["vat20_120"] = vat20_120_.value().toString();
    if(vat10_110_.has_value())res["vat10_110"] = vat10_110_.value().toString();
    if(vat5_     .has_value())res["vat5"]      = vat5_     .value().toString();
    if(vat7_     .has_value())res["vat7"]      = vat7_     .value().toString();
    if(vat5_105_ .has_value())res["vat5_105"]  = vat5_105_ .value().toString();
    if(vat7_107_ .has_value())res["vat7_107"]  = vat7_107_ .value().toString();

    if(userParam_       .has_value())res["userParam"] = userParam_.value().toMap();
    if(buyerInfo_       .has_value())res["buyerInfo"] = buyerInfo_.value().toExternalMap();
    if(operationalParam_.has_value())res["operationalParam"] = operationalParam_.value().toMap();
    if(!industryProperties_.isEmpty())
    {
        QVariantList list;
        for(const IndustryProperty &p :industryProperties_)
        {
            list << p.toMap();
        }
        res["industryProperties"] = list;
    }
    if(!buyerPhone_.isEmpty())res["buyerPhone"] = buyerPhone_;
    if(!boxId_     .isEmpty())res["boxId"]      = boxId_     ;
    if(!fnsSite_   .isEmpty())res["ftsSite"]    = fnsSite_   ;
    if(!ownerEmail_.isEmpty())res["ownerEmail"] = ownerEmail_;
    if(!operations_.isEmpty())
    {
        QVariantList list;
        QVariantList labledList;
        for(const PSimpleReceiptOperation &o :operations_)
        {
            if(o.dynamicCast<ReceiptOperation>()) labledList << o->toExternalMap();
            else list << o->toExternalMap();

        }
        if(!list.isEmpty())res["operations"] = list;
        if(!labledList.isEmpty())res["labledOperations"] = labledList;
    }
    if(t2107_ != 255)
    {
        res["labelsCheckResult"] = static_cast<qint32>(t2107_);
    }
    if(!cashier_.isEmpty()) res["cashier"] = cashier_;
    if(!cashierInn_.isEmpty()) res["cashierInn"] = cashierInn_;
    if(!additionalParam_.isEmpty()) res["additionalParam"] = additionalParam_ ;
    res["qr"] = qrText();
    return res;

}

void BaseReceiptDoc::parseMap(const QVariantMap &map)
{
    BaseWorkDoc::parseMap(map);
    receiptNumber_ = map["receipt"].toUInt();
    paymentAttr_ = static_cast<fdf::PaymentType>(map["paymentAttr"].toInt());
    tax_ = static_cast<fdf::Tax>(map["tax"].toInt());
    if(map.contains("amount")   )amount_   = FormatUtils::parseSumm("amount"   , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("change")   )change_   = FormatUtils::parseSumm("change"   , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("cash")     )cash_     = FormatUtils::parseSumm("cash"     , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("card")     )card_     = FormatUtils::parseSumm("card"     , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("prepay")   )prepay_   = FormatUtils::parseSumm("prepay"   , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("postpay")  )postpay_  = FormatUtils::parseSumm("postpay"  , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("barter")   )barter_   = FormatUtils::parseSumm("barter"   , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat20")    )vat20_    = FormatUtils::parseSumm("vat20"    , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat10")    )vat10_    = FormatUtils::parseSumm("vat10"    , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat0")     )vat0_     = FormatUtils::parseSumm("vat0"     , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vatNone")  )vatNone_  = FormatUtils::parseSumm("vatNone"  , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat20_120"))vat20_120_= FormatUtils::parseSumm("vat20_120", map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat10_110"))vat10_110_= FormatUtils::parseSumm("vat10_110", map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat5_")    )vat5_     = FormatUtils::parseSumm("vat5"     , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat7_")    )vat7_     = FormatUtils::parseSumm("vat7"     , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat5_105") )vat5_105_ = FormatUtils::parseSumm("vat5_105" , map, DEFAULT_AMOUNT_DEC);
    if(map.contains("vat7_107_"))vat7_107_ = FormatUtils::parseSumm("vat7_107" , map, DEFAULT_AMOUNT_DEC);



    if(map.contains("userParam"       ))userParam_        = ReceiptAdditionalUserParam(map["userParam"       ].toMap());
    if(map.contains("buyerInfo"       ))buyerInfo_        = BuyerInfo(map["buyerInfo"       ].toMap());
    if(map.contains("operationalParam"))operationalParam_ = ReceiptOperationalParam(map["operationalParam"].toMap());
    if(map.contains("buyerPhone"))buyerPhone_ = map["buyerPhone"].toString().trimmed();
    if(map.contains("boxId"     ))boxId_      = map["boxId"     ].toString().trimmed();
    if(map.contains("ftsSite"   ))fnsSite_    = map["ftsSite"   ].toString().trimmed();
    if(map.contains("ownerEmail"))ownerEmail_ = map["ownerEmail"].toString().trimmed();
    if(map.contains("industryProperties"))
    {
        QVariantList list = map["industryProperties"].toList();
        for(const QVariant &v :list) industryProperties_ << IndustryProperty(v.toMap());
    }
    if(map.contains("labledOperations"))
    {
        QVariantList list = map["labledOperations"].toList();
        for(const QVariant &v :list) operations_ << PSimpleReceiptOperation(new ReceiptOperation(v.toMap()));
    }
    if(map.contains("operations"))
    {
        QVariantList list = map["operations"].toList();
        for(const QVariant &v :list) operations_ << PSimpleReceiptOperation(new SimpleReceiptOperation(v.toMap()));
    }
    t2107_ = 255;
    if(map.contains("labelsCheckResult")) t2107_ = static_cast<quint8>(map["labelsCheckResult"].toUInt());
    if(map.contains("cashier"))cashier_ = map["cashier"].toString().trimmed();
    if(map.contains("cashierInn"))cashierInn_ = map["cashierInn"].toString().trimmed();
    if(map.contains("additionalParam"))additionalParam_ = map["additionalParam"].toString().trimmed();

}

void BaseReceiptDoc::setRegData(const RegData &rd, bool replace)
{
    BaseWorkDoc::setRegData(rd, replace);
    ownerEmail_ = rd.email();
    fnsSite_ = rd.ftsSite();
    if(boxId_.isEmpty()) boxId_ = rd.boxId();
}

void BaseReceiptDoc::setIncoming(const Receipt &r)
{
    paymentAttr_ = r.paymentAttr();
    tax_ = r.tax();
    amount_ = r.amount();
    FixNumber ch = r.change();
    if(ch.value() <= 0 || ch.value() > r.cash().value_or(FixNumber(DEFAULT_AMOUNT_MULT, 0ll)).value())
    {
        cash_ = r.cash_;
        change_.reset();
    }
    else
    {
        cash_ = r.cash().value_or(FixNumber(DEFAULT_AMOUNT_MULT, 0ll)) - ch;
        change_ = ch;
    }
    card_ = r.card_;
    prepay_  = r.prepay_;
    postpay_ = r.postpay_;
    barter_ = r.barter_;
    vat20_ = r.vat20();
    vat10_ = r.vat10();
    vat0_ = r.vat0();
    vatNone_ = r.vatNone();
    vat20_120_ = r.vat20_120();
    vat10_110_ = r.vat10_110();
    vat5_ = r.vat5();
    vat7_ = r.vat7();
    vat5_105_ = r.vat5_105();
    vat7_107_ = r.vat7_107();
    userParam_ = r.userParam_;
    buyerInfo_ = r.buyerInfo_;
    industryProperties_ = r.industryProperties_;
    operationalParam_ = r.operationalParam_;
    buyerPhone_ = r.buyerPhone_;
    boxId_ = r.boxId_;
    operations_ = r.operations_;
    t2107_ = r.t2107();

    if(cashier_        .isEmpty()) cashier_            = r.cashier();
    if(cashierInn_     .isEmpty()) cashierInn_         = r.cashierInn();
    if(additionalParam_.isEmpty()) additionalParam_    = r.additionalParam();
    if(ownerName_      .isEmpty()) ownerName_          = r.ownerName();
    if(address_        .isEmpty()) address_            = r.address();
    if(place_          .isEmpty()) place_              = r.place();
}


BaseReceiptDoc *BaseReceiptDoc::createReceiptDoc(const Receipt &receipt, QObject *parent)
{
    BaseReceiptDoc *res = nullptr;
    switch (receipt.needDocType()) {
    case fdf::DocType::Receipt       : res = new ReceiptDoc(parent); break;
    case fdf::DocType::Correction    : res = new CorrectionDoc(parent); break;
    case fdf::DocType::Fosa          : res = new FosaDoc(parent); break;
    case fdf::DocType::FosaCorrection: res = new CorrectionFosaDoc(parent); break;
    default: return nullptr;
    }
    res->setIncoming(receipt);
    return res;
}

quint8 BaseReceiptDoc::t2107() const
{
    return t2107_;
}

void BaseReceiptDoc::setT2107(quint8 newT2107)
{
    t2107_ = newT2107;
}




BaseReceiptDoc::BaseReceiptDoc(fdf::DocType type, QObject *parent)
    : BaseWorkDoc(type, parent)
    , receiptNumber_(0)
    , paymentAttr_(fdf::PaymentType::Invalid)
    , tax_(fdf::Tax::Invalid)
    , amount_()
    , change_()
    , cash_()
    , card_()
    , prepay_()
    , postpay_()
    , barter_()
    , vat20_()
    , vat10_()
    , vat0_()
    , vatNone_()
    , vat20_120_()
    , vat10_110_()
    , vat5_()
    , vat7_()
    , vat5_105_()
    , vat7_107_()
    , userParam_()
    , buyerInfo_()
    , industryProperties_()
    , operationalParam_()
    , buyerPhone_()
    , boxId_()
    , fnsSite_()
    , ownerEmail_()
    , cashier_()
    , cashierInn_()
    , additionalParam_()
    , operations_()
    , t2107_(255)
{

}

void BaseReceiptDoc::parseFromTlv(const Tlv &tlv)
{
    switch (tlv.tag()) {
    case fdf::Tag::ReceiptItem:
    {
        PSimpleReceiptOperation op;
        if(tlv.toMultiStlv().contains(fdf::Tag::ProductCode))
        {
            op = PSimpleReceiptOperation(new ReceiptOperation());
        }
        else
        {
            op = PSimpleReceiptOperation(new SimpleReceiptOperation());
        }
        op->parseTlv(tlv.toStlv());
        operations_ << op;
    }break;
    case fdf::Tag::Receipt: receiptNumber_ = tlv.toUInt32();break;
    case fdf::Tag::ReceiptType: paymentAttr_ = static_cast<fdf::PaymentType>(tlv.toByte());break;
    case fdf::Tag::TaxSystem: tax_ = static_cast<fdf::Tax>(tlv.toByte());break;
    case fdf::Tag::ReceiptTotal: amount_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptCash: cash_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptCard: card_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptPrepaymentAmount: prepay_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptPostpaymentAmount: postpay_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptBarterAmount: barter_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptVat0Amount: vat0_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptVat10Amount: vat10_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptVat10_110Amount: vat10_110_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptVat20Amount: vat20_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::Vat20_120Amount: vat20_120_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::ReceiptVatNoneAmount: vatNone_ = FixNumber(DEFAULT_AMOUNT_MULT, tlv.toVln());break;
    case fdf::Tag::VatAmounts:
    {        
        ReceiptsVatAmounts as;
        as.parseTlv(tlv);
        if(as.vat5().has_value())
        {
            vat5_ = as.vat5()->amount();
        }
        if(as.vat7().has_value())vat7_ = as.vat7()->amount();
        if(as.vat5_105().has_value())vat5_105_ = as.vat5_105()->amount();
        if(as.vat7_107().has_value())vat7_107_ = as.vat7_107()->amount();
    }break;
    case fdf::Tag::OwnerAdditionalParam:
    {
        ReceiptAdditionalUserParam up;
        up.parseTlv(tlv);
        userParam_ = up;
    }break;
    case fdf::Tag::ClientInfo:
    {
        BuyerInfo bi;
        bi.parseTlv(tlv);
        buyerInfo_ = bi;
    }break;
    case fdf::Tag::IndustryReceiptParam:
    {
        IndustryProperty p;
        p.parseTlv(tlv);
        industryProperties_ << p;
    }break;
    case fdf::Tag::ReceiptOperationalParam:
    {
        ReceiptOperationalParam op;
        op.parseTlv(tlv);
       operationalParam_ = op;
    }break;
    case fdf::Tag::ClientPhone: buyerPhone_ = tlv.toString().trimmed();break;
    case fdf::Tag::BoxId: boxId_ = tlv.toString().trimmed();break;
    case fdf::Tag::FnsSite: fnsSite_ = tlv.toString().trimmed();break;
    case fdf::Tag::OwnerEmail: ownerEmail_ = tlv.toString().trimmed();break;
    case fdf::Tag::Cashier: cashier_ = tlv.toString().trimmed();break;
    case fdf::Tag::CashierInn: cashierInn_ = tlv.toString().trimmed();break;
    case fdf::Tag::ReceiptAdditionalParam: additionalParam_ = tlv.toString().trimmed();break;
    case fdf::Tag::LabelProductsCheckresults: t2107_ = tlv.toByte() ;break;

    default:
        BaseWorkDoc::parseFromTlv(tlv);
        break;
    }
}


//--------------------------------------------------------------------------------------------------
ReceiptDoc::ReceiptDoc(QObject *parent)
    : BaseReceiptDoc(fdf::DocType::Receipt, parent)
{

}

ReceiptDoc::~ReceiptDoc()
{

}

void ReceiptDoc::parseMap(const QVariantMap &map)
{
    clean();
    BaseReceiptDoc::parseMap(map);
}
//--------------------------------------------------------------------------------------------------

CorrectionDoc::CorrectionDoc(QObject *parent)
    : BaseReceiptDoc(fdf::DocType::Correction, parent)
    , correctionReason_()

{

}

CorrectionDoc::~CorrectionDoc()
{

}

const CorrectionReason &CorrectionDoc::correctionReason() const
{
    return correctionReason_;
}

void CorrectionDoc::setCorrectionReason(const CorrectionReason &newCorrectionReason)
{
    correctionReason_ = newCorrectionReason;
}

void CorrectionDoc::clean()
{
    BaseReceiptDoc::clean();
    correctionReason_ = CorrectionReason();
}

QVariantMap CorrectionDoc::toMap() const
{
    QVariantMap res = BaseReceiptDoc::toMap();
    res["correctionReason"] = correctionReason_.toMap();
    return res;
}

QVariantMap CorrectionDoc::toExternalMap() const
{
    QVariantMap res = BaseReceiptDoc::toExternalMap();
    res["correctionReason"] = correctionReason_.toMap();
    return res;
}

void CorrectionDoc::parseMap(const QVariantMap &map)
{
    clean();
    BaseReceiptDoc::parseMap(map);
    correctionReason_.parseMap(map["correctionReason"].toMap());
}

void CorrectionDoc::setIncoming(const Receipt &r)
{
    BaseReceiptDoc::setIncoming(r);
    correctionReason_ = r.correctionReason().value_or(CorrectionReason());
}


CorrectionDoc::CorrectionDoc(fdf::DocType type, QObject *parent)
    : BaseReceiptDoc(type, parent)
{

}

void CorrectionDoc::parseFromTlv(const Tlv &tlv)
{
    if(tlv.tag() == fdf::Tag::CorrectionReason)
    {
        correctionReason_.parseTlv(tlv);
    }
    if(tlv.tag() == fdf::Tag::CorrectionType)
    {
        correctionReason_.setIsIndependent(!tlv.toBool());
    }
    else BaseReceiptDoc::parseFromTlv(tlv);
}

//--------------------------------------------------------------------------------------------------

FosaDoc::FosaDoc(QObject *parent)
    : BaseReceiptDoc(fdf::DocType::Fosa, parent)
{

}

FosaDoc::~FosaDoc()
{

}

void FosaDoc::parseMap(const QVariantMap &map)
{
    clean();
    BaseReceiptDoc::parseMap(map);
}

//--------------------------------------------------------------------------------------------------

CorrectionFosaDoc::CorrectionFosaDoc(QObject *parent)
    : CorrectionDoc(fdf::DocType::FosaCorrection, parent)
{

}

CorrectionFosaDoc::~CorrectionFosaDoc()
{

}


