#ifndef RECEIPTDOC_H
#define RECEIPTDOC_H

#include "basedoc.h"
#include "receipt.h"

class BaseReceiptDoc: public BaseWorkDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseReceiptDoc)
public:
    ~BaseReceiptDoc()override;

    quint16 receiptNumber() const;
    void setReceiptNumber(quint16 newReceiptNumber);

    fdf::PaymentType paymentAttr() const;
    void setPaymentAttr(fdf::PaymentType newPaymentAttr);

    fdf::Tax tax() const;
    void setTax(fdf::Tax newTax);

    FixNumber amount() const;
    void setAmount(const FixNumber &newAmount);

    std::optional<FixNumber> change() const;
    void setChange(std::optional<FixNumber> newChange);

    std::optional<FixNumber> cash() const;
    void setCash(std::optional<FixNumber> newCash);

    std::optional<FixNumber> card() const;
    void setCard(std::optional<FixNumber> newCard);

    std::optional<FixNumber> prepay() const;
    void setPrepay(std::optional<FixNumber> newPrepay);

    std::optional<FixNumber> postpay() const;
    void setPostpay(std::optional<FixNumber> newPostpay);

    std::optional<FixNumber> barter() const;
    void setBarter(std::optional<FixNumber> newBarter);

    std::optional<FixNumber> vat20() const;
    void setVat20(std::optional<FixNumber> newVat20);

    std::optional<FixNumber> vat10() const;
    void setVat10(std::optional<FixNumber> newVat10);

    std::optional<FixNumber> vat0() const;
    void setVat0(std::optional<FixNumber> newVat0);

    std::optional<FixNumber> vatNone() const;
    void setVatNone(std::optional<FixNumber> newVatNone);

    std::optional<FixNumber> vat20_120() const;
    void setVat20_120(std::optional<FixNumber> newVat20_120);

    std::optional<FixNumber> vat10_110() const;
    void setVat10_110(std::optional<FixNumber> newVat10_110);

    std::optional<FixNumber> vat5() const;
    void setVat5(std::optional<FixNumber> newVat5);

    std::optional<FixNumber> vat7() const;
    void setVat7(std::optional<FixNumber> newVat7);

    std::optional<FixNumber> vat5_105() const;
    void setVat5_105(std::optional<FixNumber> newVat5_105);

    std::optional<FixNumber> vat7_107() const;
    void setVat7_107(std::optional<FixNumber> newVat7_107);

    std::optional<ReceiptAdditionalUserParam> userParam() const;
    void setUserParam(std::optional<ReceiptAdditionalUserParam> newUserParam);

    std::optional<BuyerInfo> buyerInfo() const;
    void setBuyerInfo(std::optional<BuyerInfo> newBuyerInfo);

    const QList<IndustryProperty> &industryProperties() const;
    void setIndustryProperties(const QList<IndustryProperty> &newIndustryProperties);

    std::optional<ReceiptOperationalParam> operationalParam() const;
    void setOperationalParam(std::optional<ReceiptOperationalParam> newOperationalParam);

    const QString &buyerPhone() const;
    void setBuyerPhone(const QString &newBuyerPhone);

    const QString &boxId() const;

    const QString &fnsSite() const;
    void setFnsSite(const QString &newFnsSite);

    const QString &ownerEmail() const;
    void setOwnerEmail(const QString &newOwnerEmail);

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);


    const PSimpleReceiptOperations &operations() const;
    void setOperations(const PSimpleReceiptOperations &newOperations);

    QString qrText() const;

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setRegData(const RegData &rd, bool replace = false) override;
    virtual void setIncoming(const Receipt &r);

    static BaseReceiptDoc *createReceiptDoc(const Receipt &receipt, QObject *parent = nullptr);


    quint8 t2107() const;
    void setT2107(quint8 newT2107);



protected:
    quint16 receiptNumber_;
    fdf::PaymentType paymentAttr_;
    fdf::Tax tax_;
    FixNumber amount_;
    std::optional<FixNumber> change_;
    std::optional<FixNumber> cash_;
    std::optional<FixNumber> card_;
    std::optional<FixNumber> prepay_;
    std::optional<FixNumber> postpay_;
    std::optional<FixNumber> barter_;
    std::optional<FixNumber> vat20_;
    std::optional<FixNumber> vat10_;
    std::optional<FixNumber> vat0_;
    std::optional<FixNumber> vatNone_;
    std::optional<FixNumber> vat20_120_;
    std::optional<FixNumber> vat10_110_;
    std::optional<FixNumber> vat5_;
    std::optional<FixNumber> vat7_;
    std::optional<FixNumber> vat5_105_;
    std::optional<FixNumber> vat7_107_;
    std::optional<ReceiptAdditionalUserParam> userParam_;
    std::optional<BuyerInfo> buyerInfo_;
    QList<IndustryProperty> industryProperties_;
    std::optional<ReceiptOperationalParam> operationalParam_;
    QString buyerPhone_;
    QString boxId_;
    QString fnsSite_;
    QString ownerEmail_;
    QString cashier_;
    QString cashierInn_;
    QString additionalParam_;
    PSimpleReceiptOperations operations_;
    quint8 t2107_;

    explicit BaseReceiptDoc(fdf::DocType type, QObject *parent = nullptr);

    void parseFromTlv(const Tlv &tlv) override;

};
//--------------------------------------------------------------------------------------------------
class ReceiptDoc :public BaseReceiptDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(ReceiptDoc)
public:
    explicit ReceiptDoc(QObject *parent = nullptr);
    ~ReceiptDoc() override;

    void parseMap(const QVariantMap &map) override;
};
//--------------------------------------------------------------------------------------------------
class CorrectionDoc :public BaseReceiptDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(CorrectionDoc)
public:
    explicit CorrectionDoc(QObject *parent = nullptr);
    ~CorrectionDoc() override;

    const CorrectionReason &correctionReason() const;
    void setCorrectionReason(const CorrectionReason &newCorrectionReason);

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;
    void setIncoming(const Receipt &r) override;


protected:
    CorrectionReason correctionReason_;

    CorrectionDoc(fdf::DocType type, QObject *parent = nullptr);
    void parseFromTlv(const Tlv &tlv) override;

};

//--------------------------------------------------------------------------------------------------
class FosaDoc :public BaseReceiptDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(FosaDoc)
public:
    explicit FosaDoc(QObject *parent = nullptr);
    ~FosaDoc() override;

    void parseMap(const QVariantMap & map) override;
};
//--------------------------------------------------------------------------------------------------
class CorrectionFosaDoc :public CorrectionDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(CorrectionFosaDoc)
public:
    explicit CorrectionFosaDoc(QObject *parent = nullptr);
    ~CorrectionFosaDoc() override;
private:

};
#endif // RECEIPTDOC_H
