#ifndef REGDOC_H
#define REGDOC_H

#include "basedoc.h"
#include "regdata.h"
#include "fscounters.h"

class BaseRegDoc : public BaseDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseRegDoc)
public:
    ~BaseRegDoc() override;

    const CoreRegData &data() const;
    void setData(const CoreRegData &newData);

    RegData regData() const;


    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;


protected:
    CoreRegData data_;

    explicit BaseRegDoc(fdf::DocType docType, QObject *parent = nullptr);
    void parseFromTlv(const Tlv &tlv) override;
};

//--------------------------------------------------------------------------------------------------

class RegDoc: public BaseRegDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(RegDoc)
public:
    explicit RegDoc(QObject *parent = nullptr);
    ~RegDoc() override;
};

//--------------------------------------------------------------------------------------------------

class ReRegDoc: public BaseRegDoc
{
    Q_OBJECT
    Q_DISABLE_COPY(ReRegDoc)
public:
    explicit ReRegDoc(QObject *parent = nullptr);
    ~ReRegDoc() override;

    const TaggedFsCounters &fsCounters() const;
    void setFsCounters(const TaggedFsCounters &newFsCounters);

    void clean() override;
    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map) override;

private:
    TaggedFsCounters fsCounters_;
    void parseFromTlv(const Tlv &tlv) override;
};

#endif // REGDOC_H
