#include "basedatavalidator.h"

#include "inn.h"
#include "regnumber.h"
#include "formatutils.h"


BaseDataValidator::BaseDataValidator(QObject *parent)
    : QObject(parent)
    , lastError_(CoreApiConst::ErrorCode::Ok)
    , lastErrorMsg_()
{

}

BaseDataValidator::~BaseDataValidator()
{

}

CoreApiConst::ErrorCode BaseDataValidator::lastError() const
{
    return lastError_;
}

const QString &BaseDataValidator::lastErrorMsg() const
{
    return lastErrorMsg_;
}

void BaseDataValidator::cleanErrors()
{
    lastError_ = CoreApiConst::ErrorCode::Ok;
    lastErrorMsg_.clear();
}

bool BaseDataValidator::checkInn(const QString &inn, bool canBeEmpty)
{
    Inn i(inn);
    return i.isValid(canBeEmpty);
}

bool BaseDataValidator::checkRegNumber(const QString &val, const QString &serial, const QString &inn)
{
    cleanErrors();
    if(!checkInn(inn, false))
    {
        lastError_ = CoreApiConst::ErrorCode::InvalidUserInn;
        lastErrorMsg_  = tr("Некорректный ИНН пользователя");
        return false;
    }
    RegNumber rn(val, serial, inn);
    if(!rn.isValid())
    {
        lastError_ = CoreApiConst::ErrorCode::InvalidRegNumber;
        lastErrorMsg_  = tr("Некорректный РНМ");
        return false;
    }
    return true;
}

bool BaseDataValidator::checkString(const QString &val, qint32 maxLen, bool fixedLen,
                                    bool canBeEmpty, QString &suffixMsg)
{
    return FormatUtils::checkString(val, maxLen, fixedLen, canBeEmpty, suffixMsg);
}

bool BaseDataValidator::checkEmail(const QString &val, qint32 maxLen,
                                   bool canBeEmpty, QString &suffixMsg)
{
    return FormatUtils::checkEmail(val, maxLen, canBeEmpty, suffixMsg);
}
