#ifndef BASEDATAVALIDATOR_H
#define BASEDATAVALIDATOR_H

#include "coreapiconst.h"
#include <QObject>

class BaseDataValidator : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseDataValidator)
public:
    explicit BaseDataValidator(QObject *parent = nullptr);
    ~BaseDataValidator() override;

    CoreApiConst::ErrorCode lastError() const;

    const QString &lastErrorMsg() const;

signals:
    void errorText(QString msg);
    void error(CoreApiConst::ErrorCode code, QString txt);
    void success();
protected:
    CoreApiConst::ErrorCode lastError_;
    QString lastErrorMsg_;


    void cleanErrors();
    bool checkInn(const QString &inn, bool canBeEmpty);
    bool checkRegNumber(const QString &val, const QString &serial, const QString &inn);
    bool checkString(const QString &val, qint32 maxLen, bool fixedLen,
                     bool canBeEmpty, QString &suffixMsg);
    bool checkEmail(const QString &val, qint32 maxLen,
                     bool canBeEmpty, QString &suffixMsg);
};

#endif // BASEDATAVALIDATOR_H
