#ifndef REGDATAVALIDATOR_H
#define REGDATAVALIDATOR_H

#include "regdata.h"
#include "fsfullstatus.h"
#include "modeldata.h"
#include "basedatavalidator.h"

class RegDataValidator : public BaseDataValidator
{
    Q_OBJECT
    Q_DISABLE_COPY(RegDataValidator)
public:
    explicit RegDataValidator(QObject *parent = nullptr);
    ~RegDataValidator() override;

    const FsFullStatus &fs() const;
    void setFs(const FsFullStatus &newFs);

    const RegData &oldReg() const;
    void setOldReg(const RegData &newOldReg);

    const ModelData &model() const;
    void setModel(const ModelData &newModel);

    bool validate(const IncomingReg &data);
    void test(const IncomingReg &data);
signals:

private:
    FsFullStatus fs_;
    RegData oldReg_;
    ModelData model_;


    bool checkDataFormats(const IncomingReg &data);
    bool checkCashboxState(const IncomingReg &data);
    bool checkReregistration(const IncomingReg &data);

};

#endif // REGDATAVALIDATOR_H
