#ifndef FSAPI_H
#define FSAPI_H

#include "fsmsg.h"

#include <QObject>

// class QSerialPort;

class FsApi: public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(FsApi)
    friend class FsWrapper;
private:
    using FsRwTimeout = fs::FsRwTimeout;
    int i2cFd_ = -1;
    quint8 readBuf_[4096];

    explicit FsApi(QObject *parent);
    ~FsApi();

    bool open();
    bool isOpen() const;
    void close();

    bool exec(const FsReq &req, FsRep &rep, FsRwTimeout timeout = qMakePair(30000, 1000));

};

#endif //FSAPI_H
