#ifndef FSARCHIVEREPORTBASE_H
#define FSARCHIVEREPORTBASE_H

#include "fixnumber.h"

#include "fsfullstatus.h"
#include <QByteArray>
#include <QString>
#include <QDateTime>
#include <QSharedPointer>

class FsArchiveReportBase
{
public:
    FsArchiveReportBase(const FsArchiveReportBase &other) noexcept;
    FsArchiveReportBase(FsArchiveReportBase &&other) noexcept;
    virtual ~FsArchiveReportBase();


    QByteArray data() const;
    void setData(const QByteArray &data);

    quint8 type() const;
    void setType(const quint8 &type);

    bool hasTicket() const;
    void setHasTicket(bool hasTicket);

    QDateTime dt() const;
    void setDt(const QDateTime &dt);

    quint32 docNumber() const;
    void setDocNumber(const quint32 &docNumber);

    quint32 fiscalCode() const;
    void setFiscalCode(quint32 newFiscalCode);

    QStringList header() const;
    void setHeader(const QStringList &header);


    fs::FFD ffd() const;
    void setFfd(fs::FFD newFfd);

    virtual quint16 cycleNumber() const;
    virtual FixNumber amount() const;

    FsArchiveReportBase &operator =(const FsArchiveReportBase &other) noexcept;
    FsArchiveReportBase &operator =(FsArchiveReportBase &&other) noexcept;
    bool operator ==(const FsArchiveReportBase &other) const noexcept;
    bool operator !=(const FsArchiveReportBase &other) const noexcept;

    virtual QVariantMap toMap() const;
    virtual QVariantMap toExternalMap() const;

    static QSharedPointer<FsArchiveReportBase> createDocument(quint8 type, bool hasTicket, const QByteArray &data,
                                                              const QStringList &header);

    static QSharedPointer<FsArchiveReportBase> createRegDocument(const QByteArray &data,
                                                                 const QStringList &header);




    const QByteArray &ticket() const;
    void setTicket(const QByteArray &newTicket);

    const QDateTime &ticketDt() const;
    void setTicketDt(const QDateTime &newTicketDt);

protected:
    QByteArray data_;
    quint8 type_;
    bool hasTicket_;
    QDateTime dt_;
    quint32 docNumber_;
    quint32 fiscalCode_;
    QStringList header_;
    bool alternative_;
    fs::FFD ffd_;
    QByteArray ticket_;
    QDateTime ticketDt_;

    FsArchiveReportBase();

    virtual bool parse(const QByteArray &data) = 0;
};

typedef QSharedPointer<FsArchiveReportBase> PFsArchiveReportBase;


//--------------------------------------------------------------------------------------------------

class FsArchiveOfdTicket
{
public:
    FsArchiveOfdTicket()noexcept;
    FsArchiveOfdTicket(const FsArchiveOfdTicket &other)noexcept;
    FsArchiveOfdTicket(FsArchiveOfdTicket &&other)noexcept;
    ~FsArchiveOfdTicket();

    qint32 fd() const;
    void setFd(qint32 newFd);

    const QDateTime &dt() const;
    void setDt(const QDateTime &newDt);

    const QByteArray &sign() const;
    void setSign(const QByteArray &newSign);

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;

    FsArchiveOfdTicket &operator =(const FsArchiveOfdTicket &other) noexcept;
    FsArchiveOfdTicket &operator =(FsArchiveOfdTicket &&other) noexcept;
    bool operator ==(const FsArchiveOfdTicket &other) const noexcept;
    bool operator !=(const FsArchiveOfdTicket &other) const noexcept;

private:
    qint32 fd_;
    QDateTime dt_;
    QByteArray sign_;
};

typedef QSharedPointer<FsArchiveOfdTicket> PFsArchiveOfdTicket;
#endif // FSARCHIVEREPORTBASE_H
