#ifndef FSCOUNTERS_H
#define FSCOUNTERS_H

#include "fdfconstants.h"
#include "fixnumber.h"
#include "tlv.h"

enum class FsTotalType: quint8
{
    CycleTotal          = 0,
    FsTotalType         = 1,
};

class FsShortOperationCounters
{
public:
    FsShortOperationCounters()noexcept;
    FsShortOperationCounters(const FsShortOperationCounters &other)noexcept;
    FsShortOperationCounters(FsShortOperationCounters &&other) = default;
    virtual ~FsShortOperationCounters();

    quint32 count() const;
    void setCount(quint32 newCount);

    const FixNumber &totalAmount() const;
    void setTotalAmount(const FixNumber &newTotalAmount);

    const FixNumber &cash() const;
    void setCash(const FixNumber &newCash);

    const FixNumber &card() const;
    void setCard(const FixNumber &newCard);

    const FixNumber &prepay() const;
    void setPrepay(const FixNumber &newPrepay);

    const FixNumber &postpay() const;
    void setPostpay(const FixNumber &newPostpay);

    const FixNumber &barter() const;
    void setBarter(const FixNumber &newBarter);

    virtual void clean();

    virtual QVariantMap toMap() const;
    virtual QVariantMap toExternalMap() const;
    virtual QString toHtml() const;
    virtual void parseMap(const QVariantMap &map);

    virtual bool parseTlv(const Tlv::MapStlv &tlv);


    FsShortOperationCounters &operator = (const FsShortOperationCounters &other) noexcept;
    FsShortOperationCounters &operator = (FsShortOperationCounters &&other) = default;
    bool operator == (const FsShortOperationCounters &other) const noexcept;
    bool operator != (const FsShortOperationCounters &other) const noexcept;

protected:
    quint32 count_;
    FixNumber totalAmount_;
    FixNumber cash_;
    FixNumber card_;
    FixNumber prepay_;
    FixNumber postpay_;
    FixNumber barter_;

};
//--------------------------------------------------------------------------------------------------
class FsOperationCounters : public FsShortOperationCounters
{

public:
    FsOperationCounters()noexcept;
    FsOperationCounters(const FsOperationCounters &other)noexcept;
    FsOperationCounters(FsOperationCounters &&other) = default;
    virtual ~FsOperationCounters();

    const FixNumber &vat20() const;
    void setVat20(const FixNumber &newVat20);

    const FixNumber &vat10() const;
    void setVat10(const FixNumber &newVat10);

    const FixNumber &vat0() const;
    void setVat0(const FixNumber &newVat0);

    const FixNumber &vatNone() const;
    void setVatNone(const FixNumber &newVatNone);

    const FixNumber &vat20_120() const;
    void setVat20_120(const FixNumber &newVat20_120);

    const FixNumber &vat10_110() const;
    void setVat10_110(const FixNumber &newVat10_110);

    virtual bool parseFromFs(const QByteArray &data);
    void clean() override;

    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    QString toHtml() const override;
    void parseMap(const QVariantMap &map) override;

    bool parseTlv(const Tlv::MapStlv &tlv) override;

    FsOperationCounters &operator = (const FsOperationCounters &other) noexcept;
    FsOperationCounters &operator = (FsOperationCounters &&other) = default;
    bool operator == (const FsOperationCounters &other) const noexcept;
    bool operator != (const FsOperationCounters &other) const noexcept;


private:
    FixNumber vat20_;
    FixNumber vat10_;
    FixNumber vat0_;
    FixNumber vatNone_;
    FixNumber vat20_120_;
    FixNumber vat10_110_;
};

//--------------------------------------------------------------------------------------------------
class FsCorrectionCounter
{
public:
    FsCorrectionCounter()noexcept;
    FsCorrectionCounter(const FsCorrectionCounter &other)noexcept;
    FsCorrectionCounter(FsCorrectionCounter &&other) = default;
    ~FsCorrectionCounter();

    quint32 count() const;
    void setCount(quint32 newCount);

    const FixNumber &amount() const;
    void setAmount(const FixNumber &newAmount);

    bool parseFromFs(const QByteArray &data);
    void clean();
    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);
    QVariantMap toExternalMap() const;
    QString toHtml() const;


    FsCorrectionCounter &operator =(const FsCorrectionCounter &other) noexcept;
    FsCorrectionCounter &operator =(FsCorrectionCounter &&other) = default;
    bool operator ==(const FsCorrectionCounter &other) const noexcept;
    bool operator !=(const FsCorrectionCounter &other) const noexcept;

private:
    quint32 count_;
    FixNumber amount_;
};

//--------------------------------------------------------------------------------------------------

class FsCorrectionCounters
{
public:
    FsCorrectionCounters()noexcept;
    FsCorrectionCounters(const FsCorrectionCounters &other)noexcept;
    FsCorrectionCounters(FsCorrectionCounters &&other) = default;
    ~FsCorrectionCounters();
    quint32 count() const;
    void setCount(quint32 newCount);

    const FsCorrectionCounter &debit() const;
    void setDebit(const FsCorrectionCounter &newDebit);

    const FsCorrectionCounter &debitRefund() const;
    void setDebitRefund(const FsCorrectionCounter &newDebitRefund);

    const FsCorrectionCounter &credit() const;
    void setCredit(const FsCorrectionCounter &newCredit);

    const FsCorrectionCounter &creditRefund() const;
    void setCreditRefund(const FsCorrectionCounter &newCreditRefund);

    bool parseFromFs(const QByteArray &data);
    void clean();
    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);
    QVariantMap toExternalMap() const;
    QString toHtml() const;

    FsCorrectionCounters &operator =(const FsCorrectionCounters &other) noexcept;
    FsCorrectionCounters &operator =(FsCorrectionCounters &&other) = default;
    bool operator ==(const FsCorrectionCounters &other) const noexcept;
    bool operator !=(const FsCorrectionCounters &other) const noexcept;

private:
    quint32 count_;
    FsCorrectionCounter debit_;
    FsCorrectionCounter debitRefund_;
    FsCorrectionCounter credit_;
    FsCorrectionCounter creditRefund_;
};

//--------------------------------------------------------------------------------------------------

class FsCounters
{
public:
    FsCounters() noexcept;
    FsCounters(const FsCounters &other) noexcept;
    FsCounters(FsCounters &&other) = default;
    ~FsCounters();

    FsTotalType type() const;
    void setType(FsTotalType newType);

    QString title() const;

    quint16 cycle() const;
    void setCycle(quint16 newCycle);

    quint32 count() const;
    void setCount(quint32 newCount);

    const FsOperationCounters &debit() const;
    void setDebit(const FsOperationCounters &newDebit);

    const FsOperationCounters &debitRefund() const;
    void setDebitRefund(const FsOperationCounters &newDebitRefund);

    const FsOperationCounters &credit() const;
    void setCredit(const FsOperationCounters &newCredit);

    const FsOperationCounters &creditRefund() const;
    void setCreditRefund(const FsOperationCounters &newCreditRefund);

    const FsCorrectionCounters &corrections() const;
    void setCorrections(const FsCorrectionCounters &newCorrections);

    FixNumber cash() const;

    bool parseFromFs(const QByteArray &data, FsTotalType type);
    void clean();

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);
    QVariantMap toExternalMap() const;
    QString toHtml() const;

    //Сделать новую хрень. для тлв. будет отличаться по чекам коррекции. возможно та же хрень на неотправленные итоги будет (иа же, что и чеки коррекции)
//    bool parseTlv(const Tlv &tlv, quint16 cycle);

    FsCounters &operator =(const FsCounters &other) noexcept;
    FsCounters &operator =(FsCounters &&other) = default;
    bool operator ==(const FsCounters &other) const noexcept;
    bool operator !=(const FsCounters &other) const noexcept;

private:
    FsTotalType type_;
    quint16 cycle_;
    quint32 count_;
    FsOperationCounters debit_;
    FsOperationCounters debitRefund_;
    FsOperationCounters credit_;
    FsOperationCounters creditRefund_;
    FsCorrectionCounters corrections_;
};

//--------------------------------------------------------------------------------------------------

class ShortTaggedFsCounters
{
public:
    enum class Type: quint8
    {
        Invalid                             = 0x00,
        NotSendedCounter                    = 0x01,
        CorrectionsCounter                  = 0x02
    };
    ShortTaggedFsCounters() noexcept;
    ShortTaggedFsCounters(const ShortTaggedFsCounters &other) noexcept;
    ShortTaggedFsCounters(ShortTaggedFsCounters &&other) = default;
    ~ShortTaggedFsCounters();

    Type type() const;
    void setType(Type newType);

    QString title() const;

    quint32 count() const;
    void setCount(quint32 newCount);

    const FsShortOperationCounters &debit() const;
    void setDebit(const FsShortOperationCounters &newDebit);

    const FsShortOperationCounters &debitRefund() const;
    void setDebitRefund(const FsShortOperationCounters &newDebitRefund);

    const FsShortOperationCounters &credit() const;
    void setCredit(const FsShortOperationCounters &newCredit);

    const FsShortOperationCounters &creditRefund() const;
    void setCreditRefund(const FsShortOperationCounters &newCreditRefund);

    void clean();
    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);
    bool parseTlv(const Tlv &tlv);

    ShortTaggedFsCounters &operator =(const ShortTaggedFsCounters &other) noexcept;
    ShortTaggedFsCounters &operator =(ShortTaggedFsCounters &&other) = default;
    bool operator ==(const ShortTaggedFsCounters &other) const noexcept;
    bool operator !=(const ShortTaggedFsCounters &other) const noexcept;



private:
    Type type_;
    quint32 count_;
    FsShortOperationCounters debit_;
    FsShortOperationCounters debitRefund_;
    FsShortOperationCounters credit_;
    FsShortOperationCounters creditRefund_;
};
//--------------------------------------------------------------------------------------------------


class TaggedFsCounters
{
public:

    TaggedFsCounters() noexcept;
    TaggedFsCounters(const TaggedFsCounters &other) noexcept;
    TaggedFsCounters(TaggedFsCounters &&other) = default;
    ~TaggedFsCounters();


    FsTotalType type() const;
    void setType(FsTotalType newType);
    QString title() const;

    quint32 count() const;
    void setCount(quint32 newCount);

    const FsOperationCounters &debit() const;
    void setDebit(const FsOperationCounters &newDebit);

    const FsOperationCounters &debitRefund() const;
    void setDebitRefund(const FsOperationCounters &newDebitRefund);

    const FsOperationCounters &credit() const;
    void setCredit(const FsOperationCounters &newCredit);

    const FsOperationCounters &creditRefund() const;
    void setCreditRefund(const FsOperationCounters &newCreditRefund);

    const ShortTaggedFsCounters &corrections() const;
    void setCorrections(const ShortTaggedFsCounters &newCorrections);


    void clean();
    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);
    bool parseTlv(const Tlv &tlv);

    TaggedFsCounters &operator =(const TaggedFsCounters &other) noexcept;
    TaggedFsCounters &operator =(TaggedFsCounters &&other) = default;
    bool operator ==(const TaggedFsCounters &other) const noexcept;
    bool operator !=(const TaggedFsCounters &other) const noexcept;

private:
    FsTotalType type_;
    quint32 count_;
    FsOperationCounters debit_;
    FsOperationCounters debitRefund_;
    FsOperationCounters credit_;
    FsOperationCounters creditRefund_;
    ShortTaggedFsCounters corrections_;
};
#endif // FSCOUNTERS_H
