#ifndef OFDFSCMD_H
#define OFDFSCMD_H

#include "fsfullstatus.h"
#include "fsmsg.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "fdfconstants.h"
#include "tlv.h"

class OfdFsCmd
{

public:
    enum class Code: quint8
    {
        Invalid                          = 0x00u,
        TransfereStatus                  = 0x01u,
        SendOfdConnectionState           = 0x02u,
        ReadOfdMsg                       = 0x03u,
        CancelOfdMsgReading              = 0x04u,
        SendOfdReceipt                   = 0x05u,
        ReadNotification                 = 0x06u,
        CancelNofification               = 0x07u,
        WriteNotificationTicket          = 0x08u,
    };

    OfdFsCmd()noexcept;
    explicit OfdFsCmd(Code code)noexcept;
    explicit OfdFsCmd(const QVariantMap &map)noexcept;
    OfdFsCmd(const OfdFsCmd &other)noexcept;
    OfdFsCmd(OfdFsCmd &&other)noexcept;
    ~OfdFsCmd();

    bool isValid() const;

    bool cmdIsTransport() const;
    bool cmdIsLabelTransport() const;
    Code cmd() const;
    void setCmd(Code newCmd);

    const QVariantMap &params() const;
    void setParams(const QVariantMap &newParams);

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);

    CoreTransaction transaction() const;

    bool ofdConnected() const;
    void setOfdConnected(bool connected);

    QByteArray ofdTicket() const;
    void setOfdTicket(const QByteArray &data);


    OfdFsCmd &operator =(const OfdFsCmd &other)noexcept;
    OfdFsCmd &operator =(OfdFsCmd &&other)noexcept;
    bool operator ==(const OfdFsCmd &other) const noexcept;
    bool operator !=(const OfdFsCmd &other) const noexcept;

private:
    Code cmd_;
    QVariantMap params_;
};


//--------------------------------------------------------------------------------------------------

class OfdTicketResult
{
public:
    OfdTicketResult() noexcept;
    explicit OfdTicketResult(const QVariantMap &map) noexcept;
    OfdTicketResult(const OfdTicketResult &other) noexcept;
    OfdTicketResult(OfdTicketResult &&other) noexcept;
    ~OfdTicketResult();

    fdf::FsTicketAnswerCode fsCode() const;
    void setFsCode(fdf::FsTicketAnswerCode newFsCode);

    fdf::OfdAnswerCode ofdCode() const;
    void setOfdCode(fdf::OfdAnswerCode newOfdCode);

    const Tlv &ofdMessage() const;
    void setOfdMessage(const Tlv &newOfdMessage);

    const Tlv::Stlv &oismProps() const;
    void setOismProps(const Tlv::Stlv &newOismProps);



    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map );

    OfdTicketResult &operator =(const OfdTicketResult &other) noexcept;
    OfdTicketResult &operator =(OfdTicketResult &&other) noexcept;
    bool operator ==(const OfdTicketResult &other) const noexcept;
    bool operator !=(const OfdTicketResult &other) const noexcept;


private:
    fdf::FsTicketAnswerCode fsCode_;
    fdf::OfdAnswerCode      ofdCode_;
    Tlv ofdMessage_;
    Tlv::Stlv oismProps_;
};

//--------------------------------------------------------------------------------------------------

class FsOfdResponse
{
public:
    explicit FsOfdResponse(const OfdFsCmd &cmd)noexcept;
    explicit FsOfdResponse(const QVariantMap &map)noexcept;
    FsOfdResponse(const FsOfdResponse &other)noexcept;
    FsOfdResponse(FsOfdResponse &&other)noexcept;
    ~FsOfdResponse();


    const OfdFsCmd &cmd() const;
    void setCmd(const OfdFsCmd &newCmd);

    CoreApiConst::ErrorCode error() const;
    void setError(CoreApiConst::ErrorCode newError);

    const QVariantMap &data() const;
    void setData(const QVariantMap &newData);

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);

    QByteArray ofdMessage() const;
    void setOfdMessage(const QByteArray &msg);

    FsTransportState transportState() const;
    void setTransportState(const FsTransportState &state);

    OfdTicketResult ticketResult() const;
    void setTicketResult(const OfdTicketResult &res);

    QByteArray errorDump() const;
    void setErrorDump(const QByteArray &dump);

    CoreApiResult toResult() const;

    FsOfdResponse &operator =(const FsOfdResponse &other) noexcept;
    FsOfdResponse &operator =(FsOfdResponse &&other) noexcept;
    bool operator ==(const FsOfdResponse &other) const noexcept;
    bool operator !=(const FsOfdResponse &other) const noexcept;

private:
    OfdFsCmd cmd_;
    CoreApiConst::ErrorCode error_;
    QVariantMap data_;
};

#endif // OFDFSCMD_H
