#ifndef OFDMSGCONTAINER_H
#define OFDMSGCONTAINER_H

#include <array>
#include <QString>
#include <QByteArray>

class BaseMsgContainer
{
public:
    virtual ~BaseMsgContainer();
    using Buf4 = QByteArray;
    using Buf2 = QByteArray;

    const QString &fsNumber() const;
    const QByteArray &container() const;

    QByteArray serialize() const;

protected:
    Buf4 sign_;
    Buf2 s_;
    Buf2 p_;
    QString fsNumber_;
    quint16 len_;
    quint16 flags_;
    quint16 crc_;
    QByteArray container_;

    BaseMsgContainer();
    BaseMsgContainer(const Buf4 &sign, const Buf2 &s, const Buf2 &p, quint16 flags,
                     const QString &fs, const QByteArray &container);

    BaseMsgContainer(const QString &fs, const QByteArray &raw);

    virtual bool parse(const QByteArray  &raw);
    virtual bool checkHeader() const = 0;
};

//--------------------------------------------------------------------------------------------------

class OfdMsgContainer :public BaseMsgContainer
{
    static const QByteArray HEADER;
    static const QByteArray S_VERSION;
    static const QByteArray P_VERSION;
public:
    OfdMsgContainer(quint16 flags, const QString &fs, const QByteArray &container);
    OfdMsgContainer(const QString &fs, const QByteArray &raw);
private:
    bool checkHeader() const override;
};
//--------------------------------------------------------------------------------------------------
class KeysMsgContainer :public BaseMsgContainer
{
    static const QByteArray HEADER;
    static const QByteArray S_VERSION;
    static const QByteArray P_VERSION;
public:
    KeysMsgContainer(quint16 flags, const QString &fs, const QByteArray &container);
    KeysMsgContainer(const QString &fs, const QByteArray &raw);
private:
    bool checkHeader() const override;
};


//--------------------------------------------------------------------------------------------------
class LabelTestContainer :public BaseMsgContainer
{
    static const QByteArray HEADER;
    static const QByteArray S_VERSION;
    static const QByteArray P_VERSION;
public:
    LabelTestContainer(quint16 flags, const QString &fs, const QByteArray &container);
    LabelTestContainer(const QString &fs, const QByteArray &raw);
private:
    bool checkHeader() const override;
};

//--------------------------------------------------------------------------------------------------
class LabelNotifyContainer :public BaseMsgContainer
{
    static const QByteArray HEADER;
    static const QByteArray S_VERSION;
    static const QByteArray P_VERSION;
public:
    LabelNotifyContainer(quint16 flags, const QString &fs, const QByteArray &container);
    LabelNotifyContainer(const QString &fs, const QByteArray &raw);
private:
    bool checkHeader() const override;
};


#endif // OFDMSGCONTAINER_H
