#ifndef TLV_H
#define TLV_H

#include "fdfconstants.h"
#include "fixnumber.h"
#include "inn.h"
#include "regnumber.h"

#include <QByteArray>
#include <QString>
#include <QList>
#include <QDataStream>
#include <QDateTime>

class Tlv
{
public:
    using Tag = fdf::Tag;
    using Stlv = QList<Tlv>;
    using MapStlv = QMap<Tlv::Tag, Tlv>;
    using MultiStlv = QMultiMap<Tlv::Tag, Tlv>;
    Tlv()noexcept;
    Tlv(const Tlv & other)noexcept;
    Tlv(Tlv &&other) noexcept;
    ~Tlv();

    bool isValid() const;

    quint16 len() const;
    qint32 rawLen() const;

    fdf::Tag tag() const;
    void setTag(fdf::Tag newTag);

    const QByteArray &value() const;
    void setValue(const QByteArray &newValue);

    QByteArray rawData() const;
    bool setRawData(const QByteArray &raw);

    Stlv toStlv(bool *ok = nullptr) const;
    void setStlv(const Stlv &list);
    void setStlv(const fdf::Tag &tag, const Stlv &list);

    MapStlv toMapStlv(bool *ok = nullptr) const;
    MultiStlv toMultiStlv(bool *ok = nullptr) const;


    quint8 toByte(bool *ok = nullptr) const;
    void setByte(quint8 byte);
    void setByte(char byte);
    void setByte(const fdf::Tag &tag, quint8 byte);
    void setByte(const fdf::Tag &tag, char byte);

    bool toBool(bool *ok = nullptr) const;
    void setBool(bool byte);
    void setBool(const fdf::Tag &tag, bool byte);


    quint16 toUInt16(bool *ok = nullptr) const;
    void setUInt16(quint16 val);
    void setUInt16(const fdf::Tag &tag, quint16 val);

    quint32 toUInt32(bool *ok = nullptr) const;
    void setUInt32(quint32 val);
    void setUInt32(const fdf::Tag &tag, quint32 val);

    qint64 toVln(bool *ok = nullptr) const;
    void setVln(qint64 val);
    void setVln(const fdf::Tag &tag, qint64 val);


    FixNumber toFvln(bool *ok = nullptr)const;
    void setFvln(const FixNumber &val);
    void setFvln(const fdf::Tag &tag, const FixNumber &val);

    //TODO: Проверить особо дату и время на часовой пояс
    QDateTime toDt(bool *ok = nullptr) const;
    void setDt(const QDateTime &dt);
    void setDt(const fdf::Tag &tag, const QDateTime &dt);

    //TODO: Проверить, не изменяется ли дата из-за часового пояса
    QDate toDate(bool *ok = nullptr) const;
    void setDate(const QDate &dt);
    void setDate(const fdf::Tag &tag, const QDate &dt);


    QString toString() const;
    void setString(const QString &str);
    void setString(const fdf::Tag &tag, const QString &str);
    void clean();

    Inn toInn(bool *ok = nullptr) const;
    void setInn(const Inn &inn);
    void setInn(const QString &inn);
    void setInn(const fdf::Tag &tag, const Inn &inn);
    void setInn(const fdf::Tag &tag, const QString &inn);

    Tlv &operator =(const Tlv &other)noexcept;
    Tlv &operator =(Tlv &&other)noexcept;
    bool operator ==(const Tlv &other) const noexcept;
    bool operator !=(const Tlv &other) const noexcept;

private:
    fdf::Tag tag_;
    QByteArray value_;
};


extern QDataStream &operator << (QDataStream &ds, const Tlv &tlv);
extern QDataStream &operator >> (QDataStream &ds, Tlv &tlv);

#endif // TLV_H
