#ifndef MODELDATASTORAGE_H
#define MODELDATASTORAGE_H

#include "cryptedsettingsstorage.h"
#include "modeldata.h"
#include "regdata.h"

#include <QObject>
#include <QMutex>
#include <QFlags>
#include <QDateTime>

class ModelDataStorage: public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ModelDataStorage)
    static const QString MAIN_FILE;
    static const QString BACK_FILE;
    friend class HwModelDataStorage;
public:
    explicit ModelDataStorage(QObject *parent = nullptr);
    virtual ~ModelDataStorage();

    ModelData getModelData();
    void setModelData(const ModelData &md);
    void cleanModelData();


    RegData getRegData();
    void setRegData(const RegData &rd);
    void cleanRegData();

    void cleanAll();


private:
    static QMutex _dataMutex;

    bool getModelData(CryptedSettingsStorage *storage, ModelData &data);
    void setModelData(CryptedSettingsStorage *storage, const ModelData &md);

    bool getRegData(CryptedSettingsStorage *storage, RegData &data);
    void setRegData(CryptedSettingsStorage *storage, const RegData &rd);

};

#endif // MODELDATASTORAGE_H
