#ifndef BASETASKPROCESSOR_H
#define BASETASKPROCESSOR_H


#include "processingdatawrapper.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "fswrapper.h"
#include <QObject>

class BaseTaskProcessor : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseTaskProcessor)
public:
    ~BaseTaskProcessor() override;


    virtual bool checkState(const CoreTransaction &task, CoreApiResult &result);

signals:
protected:
    FsWrapper *fs_;
    ProcessingDataWrapper *pdw_;

    BaseTaskProcessor(FsWrapper *fs, ProcessingDataWrapper *dw, QObject *parent = nullptr);

};

#endif // BASETASKPROCESSOR_H
