#ifndef FISCALIZATIONCONTROLLER_H
#define FISCALIZATIONCONTROLLER_H


#include "processingdatawrapper.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "fswrapper.h"
#include "basetaskprocessor.h"

#include <QObject>

class FiscalizationController : public BaseTaskProcessor
{
    Q_OBJECT
    Q_DISABLE_COPY(FiscalizationController)
public:
    FiscalizationController(FsWrapper *fs, ProcessingDataWrapper *dw, QObject *parent = nullptr);

signals:
public slots:
    CoreApiResult fiscalize(const CoreTransaction &task);
    CoreApiResult closefs(const CoreTransaction &task);

    CoreApiConst::ErrorCode syncRegData();
private:


    bool checkState(const CoreTransaction &task, CoreApiResult &result) override;

    bool startFiscalization(const IncomingReg &reg, CoreApiResult &result);
    bool fillFiscParams(const IncomingReg &reg, CoreApiResult &result);
    bool commitFiscalization(const IncomingReg &reg, CoreApiResult &result,
                             qint32 &fd, quint32 &fiscCode, QDateTime &docDt);
};

#endif // FISCALIZATIONCONTROLLER_H
