#ifndef FRWORKINGTHREAD_H
#define FRWORKINGTHREAD_H

#include "abstractworker.h"
#include "coreapiconst.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "processingqueue.h"
#include "cashier.h"
#include "processingdatawrapper.h"

#include "receiptscontroller.h"
#include "fswrapper.h"
#include "basedoc.h"


#include <QTime>
#include <QElapsedTimer>

class QTimer;

namespace qt5ext {
class AbstractWorkerThread;
}
class FrWorkingThread : public AbstractWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(FrWorkingThread)
    static const qint32 MIN_LOOP_INTERVAL = 10;
    static const qint32 MAX_LOOP_INTERVAL = 100;
public:
    FrWorkingThread();
    ~FrWorkingThread() override;
signals:
    void sendToOfd();
private:
    bool started_;
    ProcessingQueue * queue_;
    QTimer *loopTimer_;
    ProcessingDataWrapper *pdw_;
    FsWrapper *fs_;
    ReceiptsController *receipts_;

    bool doStart() final;
    bool doStop() final;

    void processTask(const CoreTransaction &task, CoreApiResult &result);

    bool checkAccess(const CoreTransaction &task, CoreApiResult &result, Cashier &cashier);
    bool getCashier(qint32 id, Cashier &cashier);
    bool getCashier(const QString &login, const QString &password, Cashier &cashier);
    Cashier getCashier(const QString &login, const QString &password);

private slots:
    void execCmd();

    bool procesFrStart();

    bool checkModelData(const CoreTransaction &task, CoreApiResult &result);
private:
    CoreApiResult getCashierNames() const;
    CoreApiResult getLogin(const CoreTransaction &task);
    CoreApiResult getCashboxStatus(const CoreTransaction &task);
    CoreApiResult getCashboxModelData(const CoreTransaction &task);
    CoreApiResult writeSerial(const CoreTransaction &task);
    CoreApiResult fiscalize(const CoreTransaction &task);
    CoreApiResult closefs(const CoreTransaction &task);
    CoreApiResult fsCounters(const CoreTransaction &task);
    CoreApiResult fsClean(const CoreTransaction &task);
    CoreApiResult downloadCashiers(const CoreTransaction &task);
    CoreApiResult saveCashier(const CoreTransaction &task);
    CoreApiResult removeCashier(const CoreTransaction &task);

    CoreApiResult downloadOfdSettings(const CoreTransaction &task);
    CoreApiResult saveOfdSettings(const CoreTransaction &task);
    CoreApiResult setDateTime(const CoreTransaction &task);

    CoreApiResult ofdFsCommand(const CoreTransaction &task);
    CoreApiResult getOfflineNotifications(const CoreTransaction &task);
    CoreApiResult selfTest(const CoreTransaction &task);
    CoreApiResult fullClear(const CoreTransaction &task);
    CoreApiResult loadConfig(const CoreTransaction &task);
    CoreApiResult saveConfig(const CoreTransaction &task);
};

#endif // FRWORKINGTHREAD_H
