#include "internalobjectsorage.h"

#include <QRandomGenerator>

QMutex InternalObjectSorage::_accessMutex;
ActiveCashiers InternalObjectSorage::_activeCashiers;
QHash<QString, qint32> InternalObjectSorage::_cashiersHash;

ModelData InternalObjectSorage::_modelData;
DeviceStatus InternalObjectSorage::_deviceStatus;
RegData InternalObjectSorage::_regData;
FsFullStatus InternalObjectSorage::_fs;
OfdSettings InternalObjectSorage::_ofd;

bool InternalObjectSorage::hasActiveCashiers()
{
    _accessMutex.lock();
    bool res = !_activeCashiers.isEmpty();
    _accessMutex.unlock();
    return res;
}

ActiveCashiers InternalObjectSorage::activeCashiers()
{
    _accessMutex.lock();
    ActiveCashiers res = _activeCashiers;
    _accessMutex.unlock();
    return res;
}

void InternalObjectSorage::setActiveCashiers(const ActiveCashiers &cashiers)
{
    _accessMutex.lock();
    _activeCashiers = cashiers;
    _cashiersHash.clear();
    for(auto it = cashiers.constBegin(); it != cashiers.constEnd(); ++it)
    {
        _cashiersHash.insert(it.value().login() + it.value().password(), it.value().id());
    }
    _accessMutex.unlock();
}

void InternalObjectSorage::setActiveCashiers(const ActiveCashiersList &cashiers)
{
    _accessMutex.lock();
    _activeCashiers.clear();
    _cashiersHash.clear();
    for(const Cashier &c :cashiers)
    {
        _activeCashiers.insert(c.id(), c);
        _cashiersHash.insert(c.login() + c.password(), c.id());
    }
    _accessMutex.unlock();
}

void InternalObjectSorage::cleanActiveCashiers()
{
    _accessMutex.lock();
    _activeCashiers.clear();
    _cashiersHash.clear();
    _accessMutex.unlock();
}

bool InternalObjectSorage::getCashier(qint32 id, Cashier &cashier)
{
    cashier = Cashier();
    bool res = false;
    _accessMutex.lock();
    if(_activeCashiers.contains(id))
    {
        res = true;
        cashier = _activeCashiers[id];
    }
    _accessMutex.unlock();
    return  res;
}

bool InternalObjectSorage::getCashier(const QString &login, const QString &password, Cashier &c)
{
    c = Cashier();
    bool res = false;
    _accessMutex.lock();
    qint32 id = -1;
    if(_cashiersHash.contains(login+password))
    {
        id = _cashiersHash[login+password];
    }
    if(_activeCashiers.contains(id))
    {
        res = true;
        c = _activeCashiers[id];
    }
    _accessMutex.unlock();
    return  res;
}


ModelData InternalObjectSorage::getModelData()
{
    _accessMutex.lock();
    ModelData res = _modelData;
    _accessMutex.unlock();
    return res;
}

void InternalObjectSorage::setModelData(const ModelData &md)
{
    _accessMutex.lock();
    _modelData = md;
    _accessMutex.unlock();
}

void InternalObjectSorage::cleanModelData()
{
    _accessMutex.lock();
    _modelData = ModelData();
    _accessMutex.unlock();
}

DeviceStatus InternalObjectSorage::deviceStatus()
{
    _accessMutex.lock();
    DeviceStatus res = _deviceStatus;
    _accessMutex.unlock();
    return res;
}

void InternalObjectSorage::setDeviceStatus(const DeviceStatus &info)
{
    _accessMutex.lock();
    _deviceStatus = info;
    _accessMutex.unlock();

}

void InternalObjectSorage::cleanDeviceStatus()
{
    _accessMutex.lock();
    _deviceStatus = DeviceStatus();
    _accessMutex.unlock();

}

RegData InternalObjectSorage::getRegData()
{
    _accessMutex.lock();
    RegData res = _regData;
    _accessMutex.unlock();
    return res;
}

void InternalObjectSorage::setRegData(const RegData &rd)
{
    _accessMutex.lock();
    _regData = rd;
    _accessMutex.unlock();
}

void InternalObjectSorage::cleanRegData()
{
    _accessMutex.lock();
    _regData = RegData();
    _accessMutex.unlock();
}

FsFullStatus InternalObjectSorage::getFs()
{
    _accessMutex.lock();
    FsFullStatus fs =_fs;
    _accessMutex.unlock();
    return fs;
}

void InternalObjectSorage::setFs(const FsFullStatus &fs)
{
    _accessMutex.lock();
    _fs = fs;
    _accessMutex.unlock();
}

void InternalObjectSorage::cleanFs(FsFullStatus::CleanFlags f)
{
    _accessMutex.lock();
    _fs.clean(f);
    _accessMutex.unlock();
}

OfdSettings InternalObjectSorage::getOfd()
{
    _accessMutex.lock();
    OfdSettings res =_ofd;
    _accessMutex.unlock();
    return res;
}

void InternalObjectSorage::setOfd(const OfdSettings &ofd)
{
    _accessMutex.lock();
    _ofd = ofd;
    _accessMutex.unlock();
}

void InternalObjectSorage::cleanOfd()
{
    _accessMutex.lock();
    _ofd = OfdSettings();
    _accessMutex.unlock();
}




InternalObjectSorage::InternalObjectSorage()
{

}

InternalObjectSorage::~InternalObjectSorage()
{

}
