#ifndef INTERNALOBJECTSORAGE_H
#define INTERNALOBJECTSORAGE_H

#include "cashier.h"
#include "modeldata.h"
#include "devicestatus.h"
#include "regdata.h"
#include "fsfullstatus.h"
#include "ofdsettings.h"

#include <optional>
#include <QMutex>

class InternalObjectSorage
{
    Q_DISABLE_COPY(InternalObjectSorage)
public:


    static bool hasActiveCashiers();
    static ActiveCashiers activeCashiers();
    static void setActiveCashiers(const ActiveCashiers &cashiers);
    static void setActiveCashiers(const ActiveCashiersList &cashiers);
    static void cleanActiveCashiers();
    static bool getCashier(qint32 id, Cashier &);
    static bool getCashier(const QString &login, const QString &password, Cashier &c);



    static ModelData getModelData();
    static void setModelData(const ModelData &md);
    static void cleanModelData();

    static DeviceStatus deviceStatus();
    static void setDeviceStatus(const DeviceStatus &info);
    static void cleanDeviceStatus();

    static RegData getRegData();
    static void setRegData(const RegData &rd);
    static void cleanRegData();

    static FsFullStatus getFs();
    static void setFs(const FsFullStatus &fs);
    static void cleanFs(FsFullStatus::CleanFlags f = FsFullStatus::CLEAN_ALL);

    static OfdSettings getOfd();
    static void setOfd(const OfdSettings &ofd);
    static void cleanOfd();



private:
    static QMutex _accessMutex;
    static ActiveCashiers _activeCashiers;
    static QHash<QString, qint32> _cashiersHash;

    static ModelData _modelData;
    static DeviceStatus _deviceStatus;
    static RegData _regData;
    static FsFullStatus _fs;
    static OfdSettings _ofd;


    InternalObjectSorage();
    ~InternalObjectSorage();

};

#define IOSG InternalObjectSorage

#endif // INTERNALOBJECTSORAGE_H

