#ifndef KEYSUPDATER_H
#define KEYSUPDATER_H

#include "fswrapper.h"
#include "syncsocketwrapper.h"
#include "coreapiconst.h"

#include "processingdatawrapper.h"
#include <QObject>

class KeysUpdater : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(KeysUpdater)
public:
    explicit KeysUpdater(FsWrapper *fs, ProcessingDataWrapper *pdw, QObject *parent = nullptr);
    ~KeysUpdater() override;

    CoreApiConst::ErrorCode lastErroCode() const;
    const QString &lastErrorMsg() const;

    CoreApiConst::ErrorCode exec(QString &printableText);

signals:

private:
    FsWrapper *fs_;
    ProcessingDataWrapper *pdw_;
    SyncSocketWrapper *socket_;
    CoreApiConst::ErrorCode lastErroCode_;
    QString lastErrorMsg_;


    CoreApiConst::ErrorCode update(const QString &addr, quint8 &a20,
                                   quint16 &srvAns, QString &srvMsg);
    QByteArray readMsg(QTcpSocket *socket) const;

    CoreApiConst::ErrorCode getKeysData(QByteArray &data);
    CoreApiConst::ErrorCode writeKeysData(const QByteArray &data, quint8 &fsAnswer,
                                          quint16 &srvAns, QString &srvMsg);

private slots:
};

#endif // KEYSUPDATER_H
