#ifndef LABELSCHECKER_H
#define LABELSCHECKER_H

#include "fswrapper.h"
#include "syncsocketwrapper.h"
#include "coreapiconst.h"
#include "processingdatawrapper.h"
#include "labelcheckdata.h"
#include "labelcheckresult.h"
#include <QObject>

class LabelsChecker : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(LabelsChecker)
public:
    explicit LabelsChecker(FsWrapper *fs, ProcessingDataWrapper *pdw, QObject *parent = nullptr);
    ~LabelsChecker() override;

    CoreApiConst::ErrorCode lastErroCode() const;
    const QString &lastErrorMsg() const;

    //LabelCheckResultb

    CoreApiConst::ErrorCode execute(const LabelCheckData &op, LabelCheckResult &result, QString &msg);


signals:

private:
    FsWrapper *fs_;
    ProcessingDataWrapper *pdw_;
    SyncSocketWrapper *socket_;
    CoreApiConst::ErrorCode lastErroCode_;
    QString lastErrorMsg_;
    QList<LabelCheckData> alternatives_;

    CoreApiConst::ErrorCode exec(const LabelCheckData &op, LabelCheckResult &result, QString &msg);
    CoreApiConst::ErrorCode execOffline(const LabelCheckData &op, LabelCheckResult &result,
                                        QString &msg);

    QByteArray readMsg(QTcpSocket *socket, qint32 tout) const;

    CoreApiConst::ErrorCode b5(bool canSkipB5, const Tlv::Stlv &in, bool &skipB5, QByteArray &data);
    CoreApiConst::ErrorCode b6(const QByteArray &data, fdf::CheckLabelFlags &flags, Tlv::Stlv &out);

    bool checkB1Result(const LabelCheckData &op,
                       fdf::LabelCodeCheckFsResult r,
                       fdf::LabelCodeCheckFsStatus s,
                       CoreApiConst::ErrorCode &err,
                       QString &msg);

    LabelCheckResult prepareFailData(const LabelCheckData &from,
                                     fdf::LabelCodeCheckFsResult r,
                                     fdf::LabelCodeCheckFsStatus s,
                                     const fdf::CheckLabelFlags &fl);
private slots:
};

#endif // LABELSCHECKER_H
