#ifndef OFDWORKER_H
#define OFDWORKER_H

#include "abstractworker.h"
#include "processingqueue.h"
#include "ofdfscmd.h"
#include "syncsocketwrapper.h"


#include <QTimer>
#include <QTcpSocket>
#include <QElapsedTimer>

class OfdWorker : public AbstractWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(OfdWorker)
    static const qint32 LOOP_INTERVAL = 100;
    static const qint32 EXCHANGE_INTERVAL = 300000;
public:
    OfdWorker();
    ~OfdWorker() override;
public slots:
    void send();
private:
    ProcessingQueue *queue_;
    QTimer *loopTimer_;
    SyncSocketWrapper *socket_;
    QElapsedTimer fsTimer_;
    QElapsedTimer timerS_;

    bool doStart() override;
    bool doStop() override;

    FsOfdResponse exec(const OfdFsCmd &cmd);

    bool syncConnectedState(bool connected, const FsTransportState &st);
    QByteArray readMsg(QTcpSocket *socket) const;

private slots:
    void loop();
    bool sendConnectionStatus(bool connected);
    bool readOfdMessage(QByteArray &msg, const QString &fsNumber);
    bool cancelOfdMessage();
    bool writeOfdTicket(const QByteArray &msg, const QString &fsNumber);
};

#endif // OFDWORKER_H
