#ifndef OISMWORKER_H
#define OISMWORKER_H

#include "abstractworker.h"
#include "processingqueue.h"
#include "ofdfscmd.h"
#include "syncsocketwrapper.h"


#include <QTimer>
#include <QTcpSocket>

class OismWorker : public AbstractWorker
{
    Q_OBJECT
    Q_DISABLE_COPY(OismWorker)
    static const qint32 LOOP_INTERVAL = 10000;
    static const qint32 EXCHANGE_INTERVAL = 300000;
public:
    OismWorker();
    ~OismWorker() override;
public slots:
    void send();
private:
    ProcessingQueue *queue_;
    QTimer *loopTimer_;
    SyncSocketWrapper *socket_;
    QElapsedTimer fsTimer_;
    QElapsedTimer timerS_;



    bool doStart() override;
    bool doStop() override;

    FsOfdResponse exec(const OfdFsCmd &cmd);

    bool syncConnectedState(bool connectToHost);
    QByteArray readMsg(QTcpSocket *socket) const;

private slots:
    void loop();
    bool readOismMessage(QByteArray &msg, const QString &fsNumber);
    bool cancelOismMessage();
    bool writeOismTicket(const QByteArray &msg, const QString &fsNumber);
};

#endif // OISMWORKER_H
