#include "processingdatawrapper.h"
#include "appdirectories.h"

#include "modeldatastorage.h"
#include "internalobjectsorage.h"

#include "devicehelper.h"
#include "cashiersstore.h"



#include <QNetworkInterface>
#include <QtConcurrent>
#include <QFile>


ProcessingDataWrapper::ProcessingDataWrapper(FsWrapper *fs, QObject *parent)
    : QObject(parent)
    , fs_(fs)
    , coreConfig_(new CoreConfigStore(this))
{

}

ProcessingDataWrapper::~ProcessingDataWrapper()
{

}

ModelData ProcessingDataWrapper::getModelData() const
{
    ModelData res = IOSG::getModelData();
    if(!res.isValid())
    {
        ModelDataStorage md(nullptr);
        res = md.getModelData();
        if(res.isValid()) IOSG::setModelData(res);
    }
    return res;
}


DeviceStatus ProcessingDataWrapper::getDeviceStatus() const
{
    DeviceStatus info = IOSG::deviceStatus();
    if(!info.isValid())
    {
        DeviceHelper h;
        info.setDsn(h.getDsn());
        info.setHwHash(h.getHardwareHash());
        info.setVersionCode(h.versionCode());
        info.setVersionText(h.versionName());
        info.setIpAddress(getIpAddress());
        info.setInterfaces(h.networkInterfaces());
        info.setMem(h.getMemInfo());
        info.setStorage(h.getStorageInfo());
        if(info.isValid())
        {
            IOSG::setDeviceStatus(info);
        }
    }
    return info;
}

FsFullStatus ProcessingDataWrapper::getFsFullStatus(FsFullStatus::CleanFlags f) const
{
    FsFullStatus status = IOSG::getFs();
//    lmWarning() << f << logvariant(status.toExternalMap());
    if(status.error() != CoreApiConst::ErrorCode::Ok) f = FsFullStatus::CLEAN_ALL;
    status.clean(f);
//    lmWarning() << f << logvariant(status.toExternalMap());
    RegData rd = readRegData();
    fs_->getFullFsStatus(status, rd.flags(), rd.extFlags().flags());
    IOSG::setFs(status);

//    lmWarning() << f << logvariant(IOSG::getFs().toExternalMap());
    return status;
}


ActiveCashiers ProcessingDataWrapper::activeCashiers() const
{
    if(!IOSG::hasActiveCashiers())
    {
        CashiersStore store;
        QList<Cashier> cashiers;
        for(int i = Cashier::SUPER_USER_ID; i <= Cashier::MAX_CASHIERS_ID; ++i)
        {
            Cashier c = store.getCashier(i);
            if(c.isSuperUser()) cashiers << c;
        }
        IOSG::setActiveCashiers(cashiers);
    }
    return IOSG::activeCashiers();
}

CashboxStatus ProcessingDataWrapper::getCashboxStatus() const
{
    CashboxStatus res;
    res.setDev(getDeviceStatus());
    res.setModelData(getModelData());
    res.setFs(getFsFullStatus());
    res.setRegData(getRegData());
    return res;
}

RegData ProcessingDataWrapper::getRegData(bool fromFs) const
{
    RegData res = IOSG::getRegData();
    FsFullStatus st = getFsFullStatus();
    if(!res.isValid())
    {
        ModelDataStorage md(nullptr);
        res = md.getRegData();
        if(res.isValid()) IOSG::setRegData(res);
    }
    if(fromFs && st.isFiscalized())
    {
        RegData rd;
        CoreApiConst::ErrorCode err = fs_->readRegData(st.lifeTime().regsCount(), rd);
        if(err == CoreApiConst::ErrorCode::Ok)
        {
            res = rd;
            ModelDataStorage md;
            md.setRegData(rd);
            if(res.isValid()) IOSG::setRegData(res);
        }
    }
    return res;
}

OfdSettings ProcessingDataWrapper::reloadOfd() const
{
    if(!getCashboxStatus().isFiscalized())
    {
        IOSG::cleanOfd();
        return OfdSettings();
    }
    OfdSettings ofd = coreConfig_->ofdConfig();
     IOSG::setOfd(ofd);
     return ofd;
}

OfdSettings ProcessingDataWrapper::getOfd() const
{
    if(!getCashboxStatus().isFiscalized())
    {
        IOSG::cleanOfd();
        return OfdSettings();
    }
    if(!IOSG::getOfd().isValid())
    {
        OfdSettings ofd = coreConfig_->ofdConfig();
        IOSG::setOfd(ofd);
    }
    return IOSG::getOfd();
}





bool ProcessingDataWrapper::getCashier(qint32 id, Cashier &cashier)
{
    cashier = Cashier();
    if(!IOSG::hasActiveCashiers())
    {
        CashiersStore store;
        QList<Cashier> cashiers;
        for(int i = Cashier::SUPER_USER_ID; i <= Cashier::MAX_CASHIERS_ID; ++i)
        {
            Cashier c = store.getCashier(i);
            if(c.isValid())cashiers << c;
        }
        IOSG::setActiveCashiers(cashiers);
    }
    return IOSG::getCashier(id, cashier);
}

bool ProcessingDataWrapper::getCashier(const QString &login, const QString &password, Cashier &cashier)
{
    cashier = Cashier();
    if(!IOSG::hasActiveCashiers())
    {
        CashiersStore store;
        QList<Cashier> cashiers;
        for(int i = Cashier::SUPER_USER_ID; i <= Cashier::MAX_CASHIERS_ID; ++i)
        {
            Cashier c = store.getCashier(i);
            if(c.isValid()) cashiers << c;
        }
        IOSG::setActiveCashiers(cashiers);
    }
    return IOSG::getCashier(login, password, cashier);
}



CoreConfigStore *ProcessingDataWrapper::coreConfig() const
{
    return coreConfig_;
}

QString ProcessingDataWrapper::getIpAddress() const
{
    return DeviceHelper().getIpAddress();
}

RegData ProcessingDataWrapper::readRegData() const
{
    RegData res = IOSG::getRegData();
    if(!res.isValid())
    {
        ModelDataStorage md(nullptr);
        res = md.getRegData();
        if(res.isValid()) IOSG::setRegData(res);
    }
    return res;
}
