#ifndef PROCESSINGDATAWRAPPER_H
#define PROCESSINGDATAWRAPPER_H

#include "modeldata.h"
#include "cashier.h"
#include "devicestatus.h"
#include "cashboxstatus.h"
#include "fswrapper.h"
#include "basedoc.h"
#include "ofdsettings.h"


#include "coreconfigstore.h"

#include <QObject>
#include <QPointer>

class ProcessingDataWrapper : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(ProcessingDataWrapper)
public:
    explicit ProcessingDataWrapper(FsWrapper *fs, QObject *parent = nullptr);
    ~ProcessingDataWrapper() override;

    ModelData getModelData() const;
    DeviceStatus getDeviceStatus() const;
    FsFullStatus getFsFullStatus(FsFullStatus::CleanFlags f = FsFullStatus::CLEAN_NONE) const;

    ActiveCashiers activeCashiers() const;
    CashboxStatus getCashboxStatus() const;

    RegData getRegData(bool fromFs = false) const;

    OfdSettings reloadOfd() const;
    OfdSettings getOfd() const;


    bool getCashier(qint32 id, Cashier &cashier);
    bool getCashier(const QString & login, const QString &password, Cashier &cashier);


    CoreConfigStore *coreConfig() const;

signals:
    void sendToOfd();
private:
    mutable QPointer<FsWrapper> fs_;
    CoreConfigStore *coreConfig_;

    QString getIpAddress() const;

    RegData readRegData() const;



};

#endif // PROCESSINGDATAWRAPPER_H
