#include "processingqueue.h"
#include "processingqueueprivate.h"



ProcessingQueue::ProcessingQueue():
    p_(new ProcessingQueuePrivate())
{

}

ProcessingQueue::~ProcessingQueue()
{
    delete p_;
    p_ = nullptr;
}

bool ProcessingQueue::enqueue(const CoreTransaction &task, ProcessingQueueCallback finished)
{
    return p_->enqueue(task, finished);
}

bool ProcessingQueue::dequeue(CoreTransaction &task)
{
    return p_->dequeue(task);
}

CoreTransaction ProcessingQueue::takeTask(bool *ok)
{
    return p_->takeTask(ok);
}




bool ProcessingQueue::storeResult(const CoreApiResult &result)
{
    bool res = p_->storeResult(result);
    return res;
}

bool ProcessingQueue::containsResult(const QString &key)
{
    return p_->containsResult(key);
}

CoreApiResult ProcessingQueue::takeResult(const QString &key, bool *ok)
{
    return p_->takeResult(key, ok);
}

qint32 ProcessingQueue::queueSize() const
{
    return p_->queueSize();
}
