#ifndef PROCESSINGQUEUE_H
#define PROCESSINGQUEUE_H

#include "coreapiresult.h"
#include "coretransaction.h"


#include <QMutex>

class ProcessingQueuePrivate;
typedef std::function<void()> ProcessingQueueCallback;

class ProcessingQueue
{
    Q_DISABLE_COPY(ProcessingQueue)
public:
    ProcessingQueue();
    virtual ~ProcessingQueue();

    bool enqueue(const CoreTransaction &task, ProcessingQueueCallback finished);
    bool dequeue(CoreTransaction &task);
    CoreTransaction takeTask(bool *ok = nullptr);

    bool storeResult(const CoreApiResult &result);
    bool containsResult(const QString &key);
    CoreApiResult takeResult(const QString &key, bool *ok = nullptr);

    qint32 queueSize() const;


private:
    ProcessingQueuePrivate *p_;
};

#endif // PROCESSINGQUEUE_H
