#include "processingqueueprivate.h"



QMutex ProcessingQueuePrivate::_taskMutex;
QMutex ProcessingQueuePrivate::_resultMutex;
ProcessingQueuePrivate::TaskQueue ProcessingQueuePrivate::_queue;
QHash<QString, CoreApiResult> ProcessingQueuePrivate::_results;
QHash<QString, ProcessingQueueCallback> ProcessingQueuePrivate::_callbacks;
QSet<QString> ProcessingQueuePrivate::_queuedOperations;

ProcessingQueuePrivate::ProcessingQueuePrivate()
{

}

ProcessingQueuePrivate::~ProcessingQueuePrivate()
{

}

bool ProcessingQueuePrivate::enqueue(const CoreTransaction &task, ProcessingQueueCallback finished)
{
    _taskMutex.lock();
    bool res = !_queuedOperations.contains(task.uid());
    if(res)
    {
        _queue.enqueue(task);
        if(finished) _callbacks.insert(task.uid(), finished);
    }
    _taskMutex.unlock();
    return true;
}

bool ProcessingQueuePrivate::dequeue(CoreTransaction &task)
{
    task = CoreTransaction();
    _taskMutex.lock();
    bool res = false;
    if(!_queue.isEmpty())
    {
        res = true;
        task = _queue.dequeue();
    }
    _taskMutex.unlock();
    return res;
}

CoreTransaction ProcessingQueuePrivate::takeTask(bool *ok)
{
    CoreTransaction res;
    bool ans = dequeue(res);
    if(ok) *ok = ans;
    return res;
}

qint32 ProcessingQueuePrivate::queueSize() const
{
    _taskMutex.lock();
    qint32 res = _queue.size();
    _taskMutex.unlock();
    return res;
}


bool ProcessingQueuePrivate::storeResult(const CoreApiResult &result)
{
    if(result.uid().isEmpty()) return false;
    _resultMutex.lock();
    if(_results.contains(result.uid())) _results[result.uid()] = result;
    else _results.insert(result.uid(), result);
    ProcessingQueueCallback finished = nullptr;
    if(_callbacks.contains(result.uid()))
    {
        finished = _callbacks[result.uid()];
    }
    _resultMutex.unlock();
    if(finished) finished();
    return true;
}

bool ProcessingQueuePrivate::containsResult(const QString &key)
{
    _resultMutex.lock();
    bool res = _results.contains(key);
    _resultMutex.unlock();
    return res;
}

CoreApiResult ProcessingQueuePrivate::takeResult(const QString &key, bool *ok)
{
    _resultMutex.lock();
    bool ans = !key.isEmpty() && _results.contains(key);
    CoreApiResult res;
    if(ans)	res = _results[key];
    if(ok) *ok =ans;
    _queuedOperations.remove(key);
    _results.remove(key);

    if(_callbacks.contains(key))
    {
        _callbacks.remove(key);
    }
    _resultMutex.unlock();
    return res;
}

