#ifndef PROCESSINGQUEUEPRIVATE_H
#define PROCESSINGQUEUEPRIVATE_H

#include "processingqueue.h"

#include <QQueue>
#include <QHash>
#include <QSharedPointer>
#include <QMutex>
#include <QSet>


class ProcessingQueuePrivate
{
    friend class ProcessingQueue;
    friend class FiscalThreadsController;
    Q_DISABLE_COPY(ProcessingQueuePrivate)
private:
    ProcessingQueuePrivate();
    ~ProcessingQueuePrivate();

    bool enqueue(const CoreTransaction &task, ProcessingQueueCallback finished);
    bool dequeue(CoreTransaction &task);
    CoreTransaction takeTask(bool *ok = nullptr);
    qint32 queueSize() const;

    bool storeResult(const CoreApiResult &result);
    bool containsResult(const QString &key);
    CoreApiResult takeResult(const QString &key, bool *ok = nullptr);

private:
    typedef QQueue<CoreTransaction> TaskQueue;
    typedef QSharedPointer<TaskQueue> PTaskQueue ;
    static QMutex _taskMutex;
    static QMutex _resultMutex;
    static TaskQueue _queue;
    static QHash<QString, CoreApiResult> _results;
    static QHash<QString, ProcessingQueueCallback> _callbacks;
    static QSet<QString> _queuedOperations;
};

#endif // PROCESSINGQUEUEPRIVATE_H
