#ifndef RECEIPTSCONTROLLER_H
#define RECEIPTSCONTROLLER_H


#include "processingdatawrapper.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "fswrapper.h"
#include "basetaskprocessor.h"
#include "receipt.h"

#include <QObject>

class ReceiptsController : public BaseTaskProcessor
{
    Q_OBJECT
    Q_DISABLE_COPY(ReceiptsController)
public:
    ReceiptsController(FsWrapper *fs, ProcessingDataWrapper *dw, QObject *parent = nullptr);

    ~ReceiptsController() override;

    bool checkState(const CoreTransaction &task, CoreApiResult &result) override;


    CoreApiResult openCycle(const CoreTransaction &task);
    CoreApiResult closeCycle(const CoreTransaction &task);
    CoreApiResult calcReport(const CoreTransaction &task);
    CoreApiResult receipt(const CoreTransaction &task, const Cashier &cashier);
    CoreApiResult correction(const CoreTransaction &task, const Cashier &cashier);
    CoreApiResult checkLabel(const CoreTransaction &task);
    CoreApiResult cleanLabels(const CoreTransaction &task);
signals:
private:

    bool canOpenCycle(CoreApiResult &result);
    bool canCloseCycle(CoreApiResult &result);

    bool canMakeReceipt(CoreApiResult &result);
    bool canCheckLabel(CoreApiResult &result);
    CoreApiResult makeReceipt(const CoreTransaction &task, Receipt &receipt, const RegData &rd);
    CoreApiConst::ErrorCode processLabledOperations(Receipt &r, QString &msg, quint32 fd);

    CoreApiConst::ErrorCode updateKeys(QString &printableText);
};

#endif // RECEIPTSCONTROLLER_H
