#ifndef REPORTSCONTROLLER_H
#define REPORTSCONTROLLER_H

#include "basetaskprocessor.h"

class ReportsController : public BaseTaskProcessor
{
    Q_OBJECT
    Q_DISABLE_COPY(ReportsController)
public:
    ReportsController(FsWrapper *fs, ProcessingDataWrapper *dw, QObject *parent = nullptr);
    ~ReportsController() override;

    CoreApiResult findFsDocument(const CoreTransaction &task);
    CoreApiResult findOfdTicket(const CoreTransaction &task);
    CoreApiResult tlvDocument(const CoreTransaction &task);
    CoreApiResult regArchiveDocument(const CoreTransaction &task);
    CoreApiResult regArchiveTlvDocument(const CoreTransaction &task);

private:
    bool checkState(const CoreTransaction &task, CoreApiResult &result) override;

    QStringList createReportHeader() const;
};

#endif // REPORTSCONTROLLER_H
