#ifndef ABSTRACTWORKER_H
#define ABSTRACTWORKER_H

#include <QObject>


class AbstractWorker : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(AbstractWorker)
public:
    AbstractWorker() noexcept;
    virtual ~AbstractWorker();

signals:
    void started();
    void stopped();
    void needQuit();
public slots:
    void start();
    void stop();
    void restart();
protected:

    virtual bool doStart() = 0;
    virtual bool doStop() = 0;
};


#endif // ABSTRACTWORKER_H
