#include "abstractworkercontroller.h"
#include "abstractworker.h"
#include "abstractworkerthread.h"

#include <QThread>
#include <QCoreApplication>


AbstractWorkerController::~AbstractWorkerController()
{

}

void AbstractWorkerController::start()
{
    if(doStart()) emit started();
    else emit stopWorker();
}

void AbstractWorkerController::beginStopping()
{
    emit stopWorker();
}

void AbstractWorkerController::stop()
{
    doStop();
    emit stopped();
}

void AbstractWorkerController::killThreads()
{
    doKillThreads();
    emit stopped();
}

AbstractWorkerController::AbstractWorkerController(QObject *parent) noexcept
    : QObject(parent)
{
}

bool AbstractWorkerController::doStop()
{
    emit stopWorker();
    while(!workingThreads_.isEmpty())
    {
        QThread::msleep(10);
        QCoreApplication::processEvents();
        for(int i = 0;  i < workingThreads_.size(); ++i)
            if(!workingThreads_[i]) workingThreads_.removeAt(i--);
    }
    return true;
}

bool AbstractWorkerController::doKillThreads()
{
    while(!workingThreads_.isEmpty())
    {
        for(int i = 0;  i < workingThreads_.size(); ++i)
        {
            if(workingThreads_[i])workingThreads_[i]->terminate();
            QThread::msleep(100);
            QCoreApplication::processEvents();
            if(!workingThreads_[i]) workingThreads_.removeAt(i--);
        }
    }
    return true;
}

QThread *AbstractWorkerController::addWorkerToThread(AbstractWorker *worker)
{
    if(!worker) return 0;

    QThread *thr = new AbstractWorkerThread(worker, this);
    workingThreads_ << thr;
    connect(this, SIGNAL(stopWorker()), thr, SLOT(quit()));
    connect(thr, SIGNAL(finished()), thr, SLOT(deleteLater()));

    connect(worker, SIGNAL(started()), this, SLOT(workerStarted()), Qt::QueuedConnection);

    connect(thr, SIGNAL(destroyed()), this, SLOT(workerStopped()));

    return thr;
}

void AbstractWorkerController::processStoppedWorker()
{
    for(int i = 0;  i < workingThreads_.size(); ++i)
        if(!workingThreads_[i]) workingThreads_.removeAt(i);
}

void AbstractWorkerController::workerStarted()
{
    processStartedWorker();
}

void AbstractWorkerController::workerStopped()
{
    processStoppedWorker();
}
