#ifndef ABSTRACTWORKERCONTROLLER_H
#define ABSTRACTWORKERCONTROLLER_H

#include <QObject>
#include <QPointer>
#include <QList>


class AbstractWorker;

class AbstractWorkerController : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(AbstractWorkerController)
public:
    virtual ~AbstractWorkerController();
signals:
    void started();
    void stopped();
    void stopWorker();
public slots:
    void start();
    void beginStopping();
    void stop();
    void killThreads();
protected:
    QList<QPointer<QThread> > workingThreads_;
    explicit AbstractWorkerController(QObject *parent = 0) noexcept;

    virtual bool doStart() = 0;
    virtual bool doStop();
    virtual bool doKillThreads();
    virtual QThread* addWorkerToThread(AbstractWorker *worker);
    virtual void processStartedWorker() {}
    virtual void processStoppedWorker();

protected slots:
    void workerStarted();
    void workerStopped();
};


#endif // ABSTRACTWORKERCONTROLLER_H
