#include "abstractworkerthread.h"
#include "abstractworker.h"







//Q_DECLARE_LOGGING_CATEGORY(TEST_CORE_THREADS)
//Q_LOGGING_CATEGORY(TEST_CORE_THREADS, "AWT")

AbstractWorkerThread::AbstractWorkerThread(AbstractWorker *worker, QObject *parent) noexcept
    : QThread(parent)
    , worker_(worker)
{
    if(!worker->objectName().isEmpty())
    {
        setObjectName(worker->objectName());
    }
    else
    {
        setObjectName(QStringLiteral("AWT")+worker->metaObject()->className());
    }
    worker_->moveToThread(this);
    connect(worker, SIGNAL(objectNameChanged(QString)),
            this, SLOT(workerObjectNameChanged(QString)),
            Qt::QueuedConnection);

//	lmCDebug(TEST_CORE_THREADS) << objectName()
//							   << QString::number(qint64(this), 16)
//							   << QString::number(qint64(worker->thread()), 16);

    connect(this, SIGNAL(started()), this, SLOT(threadStarted()));
    connect(this, SIGNAL(finished()), this, SLOT(threadFinished()));
    connect(worker, SIGNAL(needQuit()), this, SLOT(quit()), Qt::QueuedConnection);
}

AbstractWorkerThread::~AbstractWorkerThread()
{
//	lmCDebug(TEST_CORE_THREADS) << objectName();
}

void AbstractWorkerThread::run()
{
    if(worker_)
    {
        worker_->start();
        exec();
        worker_->stop();
        worker_->deleteLater();
        worker_ = nullptr;
    }
}

void AbstractWorkerThread::threadStarted()
{
//	qDebug() << objectName();
}

void AbstractWorkerThread::threadFinished()
{
//	qDebug() << objectName();
}

void AbstractWorkerThread::workerObjectNameChanged(QString oName)
{
    if(!oName.isEmpty())
    {
        setObjectName(QStringLiteral("AWT") + oName);
    }
    else
    {
        setObjectName(QStringLiteral("AWT")+sender()->metaObject()->className());
    }
}

