#ifndef ABSTRACTWORKERTHREAD_H
#define ABSTRACTWORKERTHREAD_H

#include <QThread>
#include <QPointer>

class AbstractWorker;

class AbstractWorkerThread : public QThread
{
    Q_OBJECT
    Q_DISABLE_COPY(AbstractWorkerThread)
public:
    explicit AbstractWorkerThread(AbstractWorker *worker, QObject *parent = 0) noexcept;
    virtual ~AbstractWorkerThread();
private:
    QPointer<AbstractWorker> worker_;

    void run() override;

private slots:
    void threadStarted();
    void threadFinished();
    void workerObjectNameChanged(QString oName);
};

#endif // ABSTRACTWORKERTHREAD_H
