#include "appdirectories.h"

#include "cashboxbuildconfig.h"

#include <dircreator.h>

QMutex AppDirectories::_fsMutex;
bool AppDirectories::_firstStart = true;


AppDirectories::AppDirectories() noexcept
    : workDir_(CASHBOX_DATA_PATH)
{
//    lmWarning() << "S";
    _fsMutex.lock();
    if(_firstStart)
    {
        DirCreator::checkAndCreate(workDir_);
        DirCreator::checkAndCreate(translations());
        DirCreator::checkAndCreate(modelDataDir());
        DirCreator::checkAndCreate(offlineNotifications());
        DirCreator::checkAndCreate(configDir());
        DirCreator::checkAndCreate(cacheDir());
        _firstStart = false;
    }
    _fsMutex.unlock();
    //    lmWarning() << "F";
}

AppDirectories::~AppDirectories()
{

}


QString AppDirectories::translations() const
{
    return /*workDir_ +*/ ":/translations";
}

QString AppDirectories::workDir() const
{
    return workDir_;
}

QString AppDirectories::configDir() const
{
    return workDir_ + "/cfg";
}

QString AppDirectories::cacheDir() const
{
    return workDir_ + "/cache";
}

QString AppDirectories::modelDataDir() const
{
    return workDir_ + "/model";
}



QString AppDirectories::logo() const
{
    return workDir_ + "/logo.png";
}

QString AppDirectories::offlineNotifications() const
{
    return workDir_ + "/offline";
}
