#include "coreruntimestorage.h"
#include "appdirectories.h"
#include "formatutils.h"

QMutex CoreRuntimeStorage::_mutex;


CoreRuntimeStorage::CoreRuntimeStorage(QObject *parent)
    : QObject{parent}
{
    _mutex.lock();
    store_ = new QSettings(APATH.configDir() + "/core-runtime.conf", QSettings::IniFormat, this);
    backupStore_ = new QSettings(APATH.configDir() + "/core-runtime-backup.conf", QSettings::IniFormat, this);
}

CoreRuntimeStorage::~CoreRuntimeStorage()
{
    _mutex.unlock();
}

bool CoreRuntimeStorage::update2112(const QString &fsNumber, fdf::IncorrectLabelsFlag flag, qint32 cycle)
{
    fdf::IncorrectLabelsFlags flags;
    qint32 c = value(fsNumber, "cycle", 0, [](const QVariant &a, const QVariant &b)->bool {
        return a.toInt() <= b.toInt();}).toInt();
    if(cycle == c)
    {
        flags = fdf::IncorrectLabelsFlags(value(fsNumber, "flags2112", 0,
                                                [](const QVariant &a, const QVariant &b)->bool {
                                              return a.toUInt() <= b.toUInt();}).toUInt());
    }
    flags.setFlag(flag, true);
    setVvalue(fsNumber, "cycle", cycle);
    setVvalue(fsNumber, "flags2112", static_cast<quint32>(flags));
    return true;
}

bool CoreRuntimeStorage::update2113(const QString &fsNumber, fdf::IncorrectNotificationsFlag flag, qint32 cycle)
{
    fdf::IncorrectNotificationsFlags flags;
    qint32 c = value(fsNumber, "cycle", 0, [](const QVariant &a, const QVariant &b)->bool {
                   return a.toInt() <= b.toInt();}).toInt();
    if(cycle == c)
    {
        flags = fdf::IncorrectNotificationsFlags(value(fsNumber, "flags2113", 0,
                                                       [](const QVariant &a, const QVariant &b)->bool {
                                                     return a.toUInt() <= b.toUInt();}).toUInt());
    }
    flags.setFlag(flag, true);
    setVvalue(fsNumber, "cycle", cycle);
    setVvalue(fsNumber, "flags2113", static_cast<quint32>(flags));
    return true;
}

bool CoreRuntimeStorage::get2112And2113(const QString &fsNumber, qint32 cycle, fdf::IncorrectLabelsFlags &f2112, fdf::IncorrectNotificationsFlags &f2113)
{
    f2112 = fdf::IncorrectLabelsFlags();
    f2113 = fdf::IncorrectNotificationsFlags();
    qint32 c = value(fsNumber, "cycle", 0, [](const QVariant &a, const QVariant &b)->bool {
                   return a.toInt() <= b.toInt();}).toInt();
    if(c == cycle)
    {
        f2112 = fdf::IncorrectLabelsFlags(value(fsNumber, "flags2112", 0,
                                                [](const QVariant &a, const QVariant &b)->bool {
                                                    return a.toUInt() <= b.toUInt();}).toUInt());
        f2113 = fdf::IncorrectNotificationsFlags(value(fsNumber, "flags2113", 0,
                                                       [](const QVariant &a, const QVariant &b)->bool {
                                                           return a.toUInt() <= b.toUInt();}).toUInt());
    }
    return true;
}

bool CoreRuntimeStorage::updateKeysStatus(const QString &fsNumber)
{
    setVvalue(fsNumber, "keysLastUpdatesDt",  QDate::currentDate().toString(Qt::ISODate));
    return true;
}

bool CoreRuntimeStorage::getKeysStatus(const QString &fsNumber, fs::KeysStatus &ks)
{
    QDate dt = QDate::fromString(value(fsNumber, "keysLastUpdatesDt", QString(),
                                       [](const QVariant &a, const QVariant &b)->bool {
                                           return a.toString() <= b.toString();}).toString(), Qt::ISODate);
    if(!dt.isValid() || dt.daysTo(QDate::currentDate()) > 60) ks = fs::KeysStatus::Keys60;
    else if(dt.daysTo(QDate::currentDate()) > 15)ks = fs::KeysStatus::Keys15;
    else ks = fs::KeysStatus::KeysUpdated;
    return true;
}

QVariant CoreRuntimeStorage::value(const QString &section, const QString &key,
                                   const QVariant &defaultValue,
                                   const std::function<bool (const QVariant &, const QVariant &)> &lessThen) const
{
    auto get = [section, key](QSettings *store) -> QVariant {
        store->beginGroup(section);
        QVariant res = store->value(key, QVariant());
        store->endGroup();
        return res;
    };
    QVariant a = get(store_), b = get(backupStore_);
    if(!a.isValid() && !b.isValid()) return defaultValue;
    if(!a.isValid()) return b;
    if(!b.isValid()) return a;
    return lessThen(a, b) ? b: a;
}


void CoreRuntimeStorage::setVvalue(const QString &section, const QString &key, const QVariant &value) const
{
    auto save = [section, key, value](QSettings *store) -> void {
        store->beginGroup(section);
        store->setValue(key, value);
        store->endGroup();
        store->sync();
    };
    save(store_);
    save(backupStore_);
}

