#ifndef CORERUNTIMESTORAGE_H
#define CORERUNTIMESTORAGE_H

#include "fdfconstants.h"
#include "fsmsg.h"

#include <QObject>
#include <QSettings>
#include <QMutex>
#include <functional>

//TODO: удаление файлов при фискализации нового фн

class CoreRuntimeStorage : public QObject
{
    Q_OBJECT
public:
    explicit CoreRuntimeStorage(QObject *parent = nullptr);
    ~CoreRuntimeStorage() override;


    bool update2112(const QString &fsNumber, fdf::IncorrectLabelsFlag flag, qint32 cycle);
    bool update2113(const QString &fsNumber, fdf::IncorrectNotificationsFlag flag, qint32 cycle);

    bool get2112And2113(const QString &fsNumber, qint32 cycle, fdf::IncorrectLabelsFlags &f2112,
                        fdf::IncorrectNotificationsFlags &f2113);

    bool updateKeysStatus(const QString &fsNumber);
    bool getKeysStatus(const QString &fsNumber, fs::KeysStatus &ks);

signals:

private:
    static QMutex _mutex;

    QSettings *store_ = nullptr;
    QSettings *backupStore_ = nullptr;

    QVariant value(const QString &section, const QString &key, const QVariant &defaultValue,
                   const std::function<bool(const QVariant &, const QVariant &v)> &lessThen) const;
    void setVvalue(const QString &section, const QString &key, const QVariant &value) const;
};

#endif // CORERUNTIMESTORAGE_H
