#ifndef DEVICEHELPER_H
#define DEVICEHELPER_H

#include <QString>
#include <QMutex>
#include <QDateTime>
#include <QVariantMap>

class DeviceHelper
{
    static QString _dsn;
    static QMutex _mutex;
public:
    DeviceHelper();

    QString getHardwareHash() const;
    QString getDsn() const;
    qint32 versionCode() const;
    QString versionName() const;
    QString getIpAddress() const;
    QString networkInterfaces() const;
    QVariantMap getMemInfo() const;
    QVariantMap getStorageInfo() const;

    void setDateTime(const QDateTime &dt);
    void updateTo(const QString &fileName);
};

#endif // DEVICEHELPER_H
